/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.deprecated;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GrafanaLinkEnricher
extends BaseEnricher {
    public GrafanaLinkEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-deprecated-cd-grafana-link");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                ((DeploymentFluent.MetadataNested)builder.editMetadata().addToAnnotations(GrafanaLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                ((DeploymentConfigFluent.MetadataNested)builder.editMetadata().addToAnnotations(GrafanaLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                ((ReplicaSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(GrafanaLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                ((ReplicationControllerFluent.MetadataNested)builder.editMetadata().addToAnnotations(GrafanaLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                ((DaemonSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(GrafanaLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                ((StatefulSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(GrafanaLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<JobBuilder>(){

            public void visit(JobBuilder builder) {
                ((JobFluent.MetadataNested)builder.editMetadata().addToAnnotations(GrafanaLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
    }

    public Map<String, String> getAnnotations() {
        String url = this.findGrafanaLink();
        return url != null ? Collections.singletonMap("fabric8.io/metrics-path", url) : null;
    }

    private String findGrafanaLink() {
        String defaultDashboard = this.detectDefaultDashboard();
        String query = "";
        String projectName = null;
        String version = null;
        if (StringUtils.isBlank(projectName)) {
            projectName = this.getContext().getGav().getArtifactId();
        }
        if (StringUtils.isBlank(version)) {
            version = this.getContext().getGav().getVersion();
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            query = query + "&var-project=" + projectName;
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            query = query + "&var-version=" + version;
        }
        if (query.startsWith("&")) {
            query = "?" + query.substring(1);
        }
        return String.format("dashboard/file/%s%s", defaultDashboard, query);
    }

    protected String detectDefaultDashboard() {
        String dashboard = this.getConfig(Config.metricsDashboard);
        if (StringUtils.isNotBlank((CharSequence)dashboard)) {
            return dashboard;
        }
        if (this.getContext().getProjectClassLoaders().isClassInCompileClasspath(false, new String[]{"org.apache.camel.CamelContext"})) {
            return "camel-routes.json";
        }
        return "kubernetes-pods.json";
    }

    private static enum Config implements Configs.Key
    {
        metricsDashboard;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

