/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.deprecated;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.ServiceUrlUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.net.ConnectException;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLiveEnricher
extends BaseEnricher {
    private KubernetesClient kubernetesClient;

    AbstractLiveEnricher(MavenEnricherContext buildContext, String name) {
        super((EnricherContext)buildContext, name);
    }

    boolean isOnline() {
        String isOnline = this.getConfig(Config.online);
        if (isOnline != null) {
            return Configs.asBoolean((String)isOnline);
        }
        Boolean ret = this.asBooleanFromGlobalProp("fabric8.online");
        return ret != null ? ret.booleanValue() : this.getDefaultOnline();
    }

    protected boolean getDefaultOnline() {
        return false;
    }

    protected String getExternalServiceURL(String serviceName, String protocol) {
        if (!this.isOnline()) {
            this.getLog().info("Not looking for service " + serviceName + " as we are in offline mode", new Object[0]);
            return null;
        }
        try {
            Service service;
            KubernetesClient kubernetes = this.getKubernetes();
            String ns = kubernetes.getNamespace();
            if (StringUtils.isBlank((CharSequence)ns)) {
                ns = this.getNamespace();
            }
            return (service = (Service)((ServiceResource)((NonNamespaceOperation)kubernetes.services().inNamespace(ns)).withName(serviceName)).get()) != null ? ServiceUrlUtil.getServiceURL((KubernetesClient)kubernetes, (String)serviceName, (String)ns, (String)protocol, (boolean)true) : null;
        }
        catch (Throwable e) {
            Throwable cause = e;
            boolean notFound = false;
            boolean connectError = false;
            Stack<Throwable> stack = this.unfoldExceptions(e);
            while (!stack.isEmpty()) {
                Throwable t = stack.pop();
                if (t instanceof ConnectException || "No route to host".equals(t.getMessage())) {
                    this.getLog().warn("Cannot connect to Kubernetes to find URL for service %s : %s", new Object[]{serviceName, cause.getMessage()});
                    return null;
                }
                if (!(t instanceof IllegalArgumentException) && (t.getMessage() == null || !t.getMessage().matches("^No.*found.*$"))) continue;
                this.getLog().warn("%s", new Object[]{cause.getMessage()});
                return null;
            }
            this.getLog().warn("Cannot find URL for service %s : %s", new Object[]{serviceName, cause.getMessage()});
            return null;
        }
    }

    protected Stack<Throwable> unfoldExceptions(Throwable exception) {
        Stack<Throwable> throwables = new Stack<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.push(current);
        }
        return throwables;
    }

    protected Boolean asBooleanFromGlobalProp(String prop) {
        String value = this.getContext().getConfiguration().getProperty(prop);
        if (value == null) {
            value = System.getProperty(prop);
        }
        return value != null ? Boolean.valueOf(value) : null;
    }

    private KubernetesClient getKubernetes() {
        if (this.kubernetesClient == null) {
            String namespace = this.getNamespace();
            this.kubernetesClient = new ClusterAccess(namespace).createDefaultClient(this.log);
        }
        return this.kubernetesClient;
    }

    private String getNamespace() {
        String namespace = this.getConfig(Config.namespace);
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            return namespace;
        }
        namespace = this.getContext().getConfiguration().getProperty("fabric8.namespace");
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            return namespace;
        }
        namespace = System.getProperty("fabric8.namespace");
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            return namespace;
        }
        return KubernetesHelper.getDefaultNamespace();
    }

    private static enum Config implements Configs.Key
    {
        online,
        namespace;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

