/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.deprecated;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.GitUtil;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.deprecated.AbstractLiveEnricher;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class CdEnricher
extends AbstractLiveEnricher {
    public CdEnricher(MavenEnricherContext buildContext) {
        super(buildContext, "f8-deprecated-cd");
    }

    @Override
    protected boolean getDefaultOnline() {
        String buildId = this.getBuildId();
        return buildId != null;
    }

    private String getBuildId() {
        String buildId = System.getenv("BUILD_ID");
        if (buildId == null) {
            buildId = System.getProperty("BUILD_ID");
        }
        return buildId;
    }

    public Map<String, String> getAnnotations() {
        if (this.isOnline()) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            String repoName = this.getContext().getGav().getArtifactId();
            try (Repository repository = GitUtil.getGitRepository((File)this.getContext().getProjectDirectory());){
                if (repository != null) {
                    String gitCommitId = GitUtil.getGitCommitId((Repository)repository);
                    if (gitCommitId != null) {
                        this.addGitServiceUrl(annotations, repoName, gitCommitId);
                    } else {
                        this.log.debug("No Git commit id found", new Object[0]);
                    }
                } else {
                    this.log.debug("No local Git repository found", new Object[0]);
                }
            }
            catch (IOException | GitAPIException e) {
                this.log.error("Cannot extract Git information for adding to annotations: " + e, new Object[]{e});
            }
            this.addJenkinsServiceUrl(annotations, repoName);
            return annotations;
        }
        return null;
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                ((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                ((DeploymentFluent.MetadataNested)builder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                ((DeploymentConfigFluent.MetadataNested)builder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                ((ReplicaSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                ((ReplicationControllerFluent.MetadataNested)builder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                ((DaemonSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                ((StatefulSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<JobBuilder>(){

            public void visit(JobBuilder builder) {
                ((JobFluent.MetadataNested)builder.editMetadata().addToAnnotations(CdEnricher.this.getAnnotations())).endMetadata();
            }
        });
    }

    private void addGitServiceUrl(Map<String, String> annotations, String repoName, String gitCommitId) {
        String username = this.getGitUserName();
        String gogsUrl = this.getExternalServiceURL(this.getConfig(Config.gitService), "http");
        String rootGitUrl = String.format("%s/%s/%s", gogsUrl, username, repoName);
        if (StringUtils.isNotBlank((CharSequence)(rootGitUrl = String.format("%s/%s/%s", rootGitUrl, "commit", gitCommitId)))) {
            annotations.put(Fabric8Annotations.GIT_URL.value(), rootGitUrl);
        }
    }

    private void addJenkinsServiceUrl(Map<String, String> annotations, String repoName) {
        String buildId = this.getBuildId();
        if (buildId != null) {
            annotations.put(Fabric8Annotations.BUILD_ID.value(), buildId);
            String serviceUrl = this.getExternalServiceURL(this.getConfig(Config.jenkinsService), "http");
            if (serviceUrl != null) {
                String jobUrl = String.format("%s/job/%s/%s", serviceUrl, repoName, buildId);
                annotations.put(Fabric8Annotations.BUILD_URL.value(), jobUrl);
            }
        } else {
            this.log.debug("No Jenkins annotation as no BUILD_ID could be found", new Object[0]);
        }
    }

    private String getGitUserName() {
        String userEnvVar = this.getConfig(Config.gitUserEnvVar);
        String username = System.getenv(userEnvVar);
        if (username == null) {
            username = System.getProperty(userEnvVar, "gogsadmin");
        }
        return username;
    }

    private static enum Config implements Configs.Key
    {
        gitService{
            {
                this.d = "gogs";
            }
        }
        ,
        jenkinsService{
            {
                this.d = "jenkins";
            }
        }
        ,
        gitUserEnvVar{
            {
                this.d = "GIT_USER";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

