/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.deprecated;

import com.google.common.io.Files;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.api.util.ProjectClassLoaders;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;

public class IconEnricher
extends BaseEnricher {
    private static String[] ICON_EXTENSIONS = new String[]{".svg", ".png", ".gif", ".jpg", ".jpeg"};
    private File templateTempDir;
    private File appConfigDir;
    private String iconBranch;

    public IconEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-deprecated-icon");
        String baseDir = this.getContext().getProjectDirectory().getAbsolutePath();
        this.templateTempDir = new File(this.getConfig(Config.templateTempDir, baseDir + "/target/fabric8/template-workdir"));
        this.appConfigDir = new File(this.getConfig(Config.sourceDir, baseDir + "/src/main/fabric8"));
    }

    public Map<String, String> getAnnotations(String kind) {
        String iconUrl = this.getIconUrl(this.extractIconRef());
        if (iconUrl != null) {
            this.log.info("Adding icon for %s", new Object[]{kind.toLowerCase()});
            this.log.verbose(Logger.LogVerboseCategory.BUILD, "Icon URL: %s", new Object[]{iconUrl});
            return Collections.singletonMap("fabric8.io/iconUrl", iconUrl);
        }
        this.log.debug("No icon file found for resources of type " + kind, new Object[0]);
        return null;
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                ((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(serviceBuilder.getKind()))).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                ((DeploymentFluent.MetadataNested)builder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(builder.getKind()))).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                ((DeploymentConfigFluent.MetadataNested)builder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(builder.getKind()))).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                ((ReplicaSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(builder.getKind()))).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                ((ReplicationControllerFluent.MetadataNested)builder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(builder.getKind()))).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                ((DaemonSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(builder.getKind()))).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                ((StatefulSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(builder.getKind()))).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<JobBuilder>(){

            public void visit(JobBuilder builder) {
                ((JobFluent.MetadataNested)builder.editMetadata().addToAnnotations(IconEnricher.this.getAnnotations(builder.getKind()))).endMetadata();
            }
        });
    }

    private String extractIconRef() {
        String iconRef = this.getConfig(Config.ref);
        if (StringUtils.isBlank((CharSequence)iconRef)) {
            iconRef = this.getDefaultIconRef();
        }
        return iconRef;
    }

    protected String getIconUrl(String iconRef) {
        String answer = this.getConfig(Config.url);
        if (StringUtils.isBlank((CharSequence)answer)) {
            try {
                if (this.templateTempDir != null) {
                    this.templateTempDir.mkdirs();
                    File iconFile = this.copyIconToFolder(iconRef, this.templateTempDir);
                    if (iconFile == null) {
                        this.copyAppConfigFiles(this.templateTempDir, this.appConfigDir);
                        for (String ext : ICON_EXTENSIONS) {
                            File file = new File(this.templateTempDir, "icon" + ext);
                            if (!file.exists() || !file.isFile()) continue;
                            iconFile = file;
                            break;
                        }
                    }
                    if (iconFile != null) {
                        answer = this.convertIconFileToURL(iconFile, iconRef);
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to load icon file: %s", new Object[]{e});
            }
        }
        if (StringUtils.isBlank((CharSequence)answer) && StringUtils.isNotBlank((CharSequence)iconRef)) {
            String embeddedIcon = this.embeddedIconsInConsole(iconRef, "img/icons/");
            if (embeddedIcon != null) {
                return embeddedIcon;
            }
            this.log.warn("Could not resolve iconRef: %s", new Object[]{iconRef});
        }
        return answer;
    }

    private String getDefaultIconRef() {
        ProjectClassLoaders cls = this.getContext().getProjectClassLoaders();
        if (cls.isClassInCompileClasspath(false, new String[]{"io.fabric8.funktion.runtime.Main"}) || this.getContext().hasDependency("io.fabric8.funktion", null)) {
            return "funktion";
        }
        if (cls.isClassInCompileClasspath(false, new String[]{"org.apache.camel.CamelContext"})) {
            return "camel";
        }
        if (this.getContext().hasPlugin(null, "spring-boot-maven-plugin") || cls.isClassInCompileClasspath(false, new String[]{"org.springframework.boot.SpringApplication"})) {
            return "spring-boot";
        }
        if (cls.isClassInCompileClasspath(false, new String[]{"org.springframework.core.Constants"})) {
            return "spring";
        }
        if (cls.isClassInCompileClasspath(false, new String[]{"org.vertx.java.core.Handler", "io.vertx.core.Handler"})) {
            return "vertx";
        }
        if (this.getContext().hasPlugin("org.wildfly.swarm", "wildfly-swarm-plugin") || this.getContext().hasDependency("org.wildfly.swarm", null)) {
            return "wildfly-swarm";
        }
        if (this.getContext().hasPlugin("io.thorntail", "thorntail-maven-plugin") || this.getContext().hasDependency("io.thorntail", null)) {
            return "wildfly-swarm";
        }
        return null;
    }

    private File copyIconToFolder(String iconRef, File appBuildDir) throws IOException {
        File[] icons;
        if (StringUtils.isNotBlank((CharSequence)iconRef) && ((icons = appBuildDir.listFiles((dir, name) -> {
            if (name == null) {
                return false;
            }
            String lower = name.toLowerCase();
            if (lower.startsWith("icon.")) {
                for (String ext : ICON_EXTENSIONS) {
                    if (!lower.endsWith(ext)) continue;
                    return true;
                }
            }
            return false;
        })) == null || icons.length == 0)) {
            InputStream in = this.loadPluginResource(iconRef);
            if (in == null) {
                for (String ext : ICON_EXTENSIONS) {
                    String name2 = iconRef + ext;
                    in = this.loadPluginResource(name2);
                    if (in == null) continue;
                    iconRef = name2;
                    break;
                }
            }
            if (in != null) {
                String fileName = "icon." + Files.getFileExtension((String)iconRef);
                File outFile = new File(appBuildDir, fileName);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)outFile);
                this.log.info("Generated icon file " + outFile + " from icon reference: " + iconRef, new Object[0]);
                return outFile;
            }
        }
        return null;
    }

    private InputStream loadPluginResource(String iconRef) {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(iconRef);
        if (answer == null) {
            answer = this.getContext().getProjectClassLoaders().getCompileClassLoader().getResourceAsStream(iconRef);
        }
        if (answer == null) {
            answer = ((Object)((Object)this)).getClass().getResourceAsStream(iconRef);
        }
        return answer;
    }

    private void copyAppConfigFiles(File appBuildDir, File appConfigDir) throws IOException {
        File[] files = appConfigDir.listFiles();
        if (files != null) {
            appBuildDir.mkdirs();
            for (File file : files) {
                File outFile = new File(appBuildDir, file.getName());
                if (file.isDirectory()) {
                    this.copyAppConfigFiles(outFile, file);
                    continue;
                }
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertIconFileToURL(File iconFile, String iconRef) throws IOException {
        long length = iconFile.length();
        int sizeK = Math.round(length / 1024L);
        byte[] bytes = FileUtils.readFileToByteArray((File)iconFile);
        byte[] encoded = Base64.encodeBase64((byte[])bytes);
        int base64SizeK = Math.round(encoded.length / 1024);
        if (base64SizeK < Configs.asInt((String)this.getConfig(Config.maximumDataUrlSizeK))) {
            String mimeType = URLConnection.guessContentTypeFromName(iconFile.getName());
            return "data:" + mimeType + ";charset=UTF-8;base64," + new String(encoded);
        }
        File iconSourceFile = new File(this.appConfigDir, iconFile.getName());
        if (iconSourceFile.exists()) {
            String url;
            MavenEnricherContext mavenEnricherContext;
            Scm scm;
            String urlPrefix;
            File rootProjectFolder = this.getContext().getProjectDirectory();
            if (rootProjectFolder == null || !StringUtils.isBlank((CharSequence)(urlPrefix = this.getConfig(Config.urlPrefix)))) return null;
            String relativePath = FileUtil.getRelativePath((File)rootProjectFolder, (File)iconSourceFile).toString();
            String relativeParentPath = FileUtil.getRelativePath((File)rootProjectFolder, (File)this.getContext().getProjectDirectory()).toString();
            if (this.getContext() instanceof MavenEnricherContext && (scm = (mavenEnricherContext = (MavenEnricherContext)this.getContext()).getProject().getScm()) != null && (url = scm.getUrl()) != null) {
                String[] prefixes;
                for (String prefix : prefixes = new String[]{"http://github.com/", "https://github.com/"}) {
                    if (!url.startsWith(prefix)) continue;
                    url = "https://cdn.rawgit.com/" + url.substring(prefix.length());
                    break;
                }
                if (url.endsWith(relativeParentPath)) {
                    url = url.substring(0, url.length() - relativeParentPath.length());
                }
                urlPrefix = url;
            }
            if (!StringUtils.isBlank((CharSequence)urlPrefix)) return String.format("%s/%s/%s", urlPrefix, this.getConfig(Config.branch), relativePath);
            this.log.warn("No iconUrlPrefix defined or could be found via SCM in the pom.xml so cannot add an icon URL!", new Object[0]);
            return null;
        } else {
            String embeddedIcon = this.embeddedIconsInConsole(iconRef, "img/icons/");
            if (embeddedIcon != null) {
                return embeddedIcon;
            }
            this.log.warn("Cannot find url for icon to use %s", new Object[]{iconRef});
        }
        return null;
    }

    protected String embeddedIconsInConsole(String iconRef, String prefix) {
        if (iconRef == null) {
            return null;
        }
        if (iconRef.startsWith("icons/")) {
            iconRef = iconRef.substring(6);
        }
        if (iconRef.contains("META-INF/fabric8")) {
            return "img/fabric8_icon.svg";
        }
        if (iconRef.contains("activemq")) {
            return prefix + "activemq.svg";
        }
        if (iconRef.contains("apiman")) {
            return prefix + "apiman.png";
        }
        if (iconRef.contains("api-registry")) {
            return prefix + "api-registry.svg";
        }
        if (iconRef.contains("brackets")) {
            return prefix + "brackets.svg";
        }
        if (iconRef.contains("camel")) {
            return prefix + "camel.svg";
        }
        if (iconRef.contains("chaos-monkey")) {
            return prefix + "chaos-monkey.png";
        }
        if (iconRef.contains("docker-registry")) {
            return prefix + "docker-registry.png";
        }
        if (iconRef.contains("elasticsearch")) {
            return prefix + "elasticsearch.png";
        }
        if (iconRef.contains("fluentd")) {
            return prefix + "fluentd.png";
        }
        if (iconRef.contains("forge")) {
            return prefix + "forge.svg";
        }
        if (iconRef.contains("funktion")) {
            return prefix + "funktion.png";
        }
        if (iconRef.contains("gerrit")) {
            return prefix + "gerrit.png";
        }
        if (iconRef.contains("gitlab")) {
            return prefix + "gitlab.svg";
        }
        if (iconRef.contains("gogs")) {
            return prefix + "gogs.png";
        }
        if (iconRef.contains("grafana")) {
            return prefix + "grafana.png";
        }
        if (iconRef.contains("hubot-irc")) {
            return prefix + "hubot-irc.png";
        }
        if (iconRef.contains("hubot-letschat")) {
            return prefix + "hubot-letschat.png";
        }
        if (iconRef.contains("hubot-notifier")) {
            return prefix + "hubot-notifier.png";
        }
        if (iconRef.contains("hubot-slack")) {
            return prefix + "hubot-slack.png";
        }
        if (iconRef.contains("image-linker")) {
            return prefix + "image-linker.svg";
        }
        if (iconRef.contains("javascript")) {
            return prefix + "javascript.png";
        }
        if (iconRef.contains("java")) {
            return prefix + "java.svg";
        }
        if (iconRef.contains("jenkins")) {
            return prefix + "jenkins.svg";
        }
        if (iconRef.contains("jetty")) {
            return prefix + "jetty.svg";
        }
        if (iconRef.contains("karaf")) {
            return prefix + "karaf.svg";
        }
        if (iconRef.contains("keycloak")) {
            return prefix + "keycloak.svg";
        }
        if (iconRef.contains("kibana")) {
            return prefix + "kibana.svg";
        }
        if (iconRef.contains("kiwiirc")) {
            return prefix + "kiwiirc.png";
        }
        if (iconRef.contains("letschat")) {
            return prefix + "letschat.png";
        }
        if (iconRef.contains("mule")) {
            return prefix + "mule.svg";
        }
        if (iconRef.contains("nexus")) {
            return prefix + "nexus.png";
        }
        if (iconRef.contains("node")) {
            return prefix + "node.svg";
        }
        if (iconRef.contains("orion")) {
            return prefix + "orion.png";
        }
        if (iconRef.contains("prometheus")) {
            return prefix + "prometheus.png";
        }
        if (iconRef.contains("django") || iconRef.contains("python")) {
            return prefix + "python.png";
        }
        if (iconRef.contains("spring-boot")) {
            return prefix + "spring-boot.svg";
        }
        if (iconRef.contains("taiga")) {
            return prefix + "taiga.png";
        }
        if (iconRef.contains("tomcat")) {
            return prefix + "tomcat.svg";
        }
        if (iconRef.contains("tomee")) {
            return prefix + "tomee.svg";
        }
        if (iconRef.contains("vertx")) {
            return prefix + "vertx.svg";
        }
        if (iconRef.contains("wildfly")) {
            return prefix + "wildfly.svg";
        }
        if (iconRef.contains("wildfly-swarm")) {
            return prefix + "wildfly-swarm.png";
        }
        if (iconRef.contains("weld")) {
            return prefix + "weld.svg";
        }
        if (iconRef.contains("zipkin")) {
            return prefix + "zipkin.png";
        }
        return null;
    }

    private static enum Config implements Configs.Key
    {
        templateTempDir,
        sourceDir,
        ref,
        maximumDataUrlSizeK{
            {
                this.d = "2";
            }
        }
        ,
        urlPrefix,
        branch{
            {
                this.d = "master";
            }
        }
        ,
        url;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

