/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.deprecated;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.deprecated.AbstractLiveEnricher;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;

public class DocLinkEnricher
extends AbstractLiveEnricher {
    public DocLinkEnricher(MavenEnricherContext buildContext) {
        super(buildContext, "f8-deprecated-link");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                ((DeploymentFluent.MetadataNested)builder.editMetadata().addToAnnotations(DocLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                ((DeploymentConfigFluent.MetadataNested)builder.editMetadata().addToAnnotations(DocLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                ((ReplicaSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(DocLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                ((ReplicationControllerFluent.MetadataNested)builder.editMetadata().addToAnnotations(DocLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                ((DaemonSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(DocLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                ((StatefulSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(DocLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<JobBuilder>(){

            public void visit(JobBuilder builder) {
                ((JobFluent.MetadataNested)builder.editMetadata().addToAnnotations(DocLinkEnricher.this.getAnnotations())).endMetadata();
            }
        });
    }

    public Map<String, String> getAnnotations() {
        String url = this.findDocumentationUrl();
        return url != null ? Collections.singletonMap(Fabric8Annotations.DOCS_URL.value(), url) : null;
    }

    private String getDocumentationUrl() {
        if (this.getContext() instanceof MavenEnricherContext) {
            MavenEnricherContext mavenEnricherContext = (MavenEnricherContext)this.getContext();
            for (MavenProject currentProject = mavenEnricherContext.getProject(); currentProject != null; currentProject = currentProject.getParent()) {
                Site site;
                DistributionManagement distributionManagement = currentProject.getDistributionManagement();
                if (distributionManagement == null || (site = distributionManagement.getSite()) == null) continue;
                return site.getUrl();
            }
        }
        return null;
    }

    protected String findDocumentationUrl() {
        String url = this.getDocumentationUrl();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            url = DocLinkEnricher.replaceProperties(url, this.getContext().getConfiguration().getProperties());
            try {
                String publicUrl;
                int idx2;
                String urlToParse = url;
                int idx = url.indexOf("://");
                if (idx > 0 && (idx2 = url.substring(0, idx).lastIndexOf(58)) >= 0 && idx2 < idx) {
                    urlToParse = url.substring(idx2 + 1);
                }
                URL u = new URL(urlToParse);
                String serviceName = u.getHost();
                String protocol = u.getProtocol();
                if (this.isOnline() && StringUtils.isNotBlank((CharSequence)(publicUrl = this.getExternalServiceURL(serviceName, protocol)))) {
                    return String.format("%s/%s", publicUrl, u.getPath());
                }
            }
            catch (MalformedURLException e) {
                this.getLog().error("Failed to parse URL: %s. %s", new Object[]{url, e});
            }
            return url;
        }
        return null;
    }

    protected static String replaceProperties(String text, Properties properties) {
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String pattern = "${" + key + "}";
            text = StringUtils.replace((String)text, (String)pattern, (String)value.toString());
        }
        return text;
    }
}

