/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util.kubernetes;

import com.google.common.base.Objects;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceStatus;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ServiceUrlUtil {
    private static final String DEFAULT_PROTO = "tcp";
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";

    public static String getServiceURL(KubernetesClient client, String serviceName, String serviceNamespace, String serviceProtocol, boolean serviceExternal) {
        OpenShiftClient openShiftClient;
        Route route;
        String hostAndPort;
        String actualNamespace;
        Service srv = null;
        String serviceHost = ServiceUrlUtil.serviceToHostOrBlank(serviceName);
        String servicePort = ServiceUrlUtil.serviceToPortOrBlank(serviceName);
        String serviceProto = serviceProtocol != null ? serviceProtocol : ServiceUrlUtil.serviceToProtocol(serviceName, servicePort);
        String string = actualNamespace = StringUtils.isNotBlank((CharSequence)serviceNamespace) ? serviceNamespace : client.getNamespace();
        if (!serviceExternal && StringUtils.isNotBlank((CharSequence)serviceHost) && StringUtils.isNotBlank((CharSequence)servicePort) && StringUtils.isNotBlank((CharSequence)serviceProtocol)) {
            return serviceProtocol + "://" + serviceHost + ":" + servicePort;
        }
        if (StringUtils.isNotBlank((CharSequence)actualNamespace)) {
            srv = (Service)((ServiceResource)((NonNamespaceOperation)client.services().inNamespace(actualNamespace)).withName(serviceName)).get();
        }
        if (srv == null && !(hostAndPort = ServiceUrlUtil.getServiceHostAndPort(serviceName, "", "")).startsWith(":")) {
            return serviceProto + "://" + hostAndPort;
        }
        if (srv == null) {
            throw new IllegalArgumentException("No kubernetes service could be found for name: " + serviceName + " in namespace: " + actualNamespace);
        }
        String answer = KubernetesHelper.getOrCreateAnnotations(srv).get(Fabric8Annotations.SERVICE_EXPOSE_URL.toString());
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            return answer;
        }
        if (OpenshiftHelper.isOpenShift(client) && (route = (Route)((Resource)((NonNamespaceOperation)(openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class)).routes().inNamespace(actualNamespace)).withName(serviceName)).get()) != null) {
            return (serviceProto + "://" + route.getSpec().getHost()).toLowerCase();
        }
        ServicePort port = ServiceUrlUtil.findServicePortByName(srv, null);
        if (port == null) {
            throw new RuntimeException("Couldn't find port: " + null + " for service:" + serviceName);
        }
        String clusterIP = srv.getSpec().getClusterIP();
        if ("None".equals(clusterIP)) {
            throw new IllegalStateException("Service: " + serviceName + " in namespace:" + serviceNamespace + "is head-less. Search for endpoints instead.");
        }
        Integer portNumber = port.getPort();
        if (StringUtils.isBlank((CharSequence)clusterIP)) {
            List loadBalancerIngresses;
            LoadBalancerStatus loadBalancerStatus;
            ServiceStatus status;
            List items;
            IngressList ingresses = (IngressList)((NonNamespaceOperation)client.extensions().ingresses().inNamespace(serviceNamespace)).list();
            if (ingresses != null && (items = ingresses.getItems()) != null) {
                for (Ingress item : items) {
                    IngressSpec spec;
                    String ns = KubernetesHelper.getNamespace((HasMetadata)item);
                    if (!Objects.equal((Object)serviceNamespace, (Object)ns) || (spec = item.getSpec()) == null) continue;
                    List rules = spec.getRules();
                    List tls = spec.getTls();
                    if (rules == null) continue;
                    for (IngressRule rule : rules) {
                        List paths;
                        HTTPIngressRuleValue http = rule.getHttp();
                        if (http == null || (paths = http.getPaths()) == null) continue;
                        for (HTTPIngressPath path : paths) {
                            String backendServiceName;
                            IngressBackend backend = path.getBackend();
                            if (backend == null || !serviceName.equals(backendServiceName = backend.getServiceName()) || !ServiceUrlUtil.portsMatch(port, backend.getServicePort())) continue;
                            String pathPostfix = path.getPath();
                            if (tls != null) {
                                for (IngressTLS tlsHost : tls) {
                                    List hosts = tlsHost.getHosts();
                                    if (hosts == null) continue;
                                    for (String host : hosts) {
                                        if (!StringUtils.isNotBlank((CharSequence)host)) continue;
                                        return String.format("https://%s/%s", host, ServiceUrlUtil.preparePath(pathPostfix));
                                    }
                                }
                            }
                            if (!StringUtils.isNotBlank((CharSequence)(answer = rule.getHost()))) continue;
                            return String.format("http://%s/%s", answer, ServiceUrlUtil.preparePath(pathPostfix));
                        }
                    }
                }
            }
            if ((status = srv.getStatus()) != null && (loadBalancerStatus = status.getLoadBalancer()) != null && (loadBalancerIngresses = loadBalancerStatus.getIngress()) != null) {
                for (LoadBalancerIngress loadBalancerIngress : loadBalancerIngresses) {
                    String ip = loadBalancerIngress.getIp();
                    if (!StringUtils.isNotBlank((CharSequence)ip)) continue;
                    clusterIP = ip;
                    break;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)clusterIP)) {
            List items;
            NodeList nodeList;
            boolean found = false;
            Integer nodePort = port.getNodePort();
            if (nodePort != null && (nodeList = (NodeList)client.nodes().list()) != null && (items = nodeList.getItems()) != null) {
                for (Node item : items) {
                    NodeSpec spec;
                    List addresses;
                    NodeStatus status = item.getStatus();
                    if (!found && status != null && (addresses = status.getAddresses()) != null) {
                        for (NodeAddress address : addresses) {
                            String ip = address.getAddress();
                            if (!StringUtils.isNotBlank((CharSequence)ip)) continue;
                            clusterIP = ip;
                            portNumber = nodePort;
                            found = true;
                            break;
                        }
                    }
                    if (found || (spec = item.getSpec()) == null || !StringUtils.isNotBlank((CharSequence)(clusterIP = spec.getExternalID()))) continue;
                    portNumber = nodePort;
                    break;
                }
            }
        }
        return (serviceProto + "://" + clusterIP + ":" + portNumber).toLowerCase();
    }

    private static boolean portsMatch(ServicePort servicePort, IntOrString intOrString) {
        if (intOrString != null) {
            Integer port = servicePort.getPort();
            Integer intVal = intOrString.getIntVal();
            String strVal = intOrString.getStrVal();
            if (intVal != null) {
                if (port != null) {
                    return port.intValue() == intVal.intValue();
                }
            } else if (strVal != null) {
                return Objects.equal((Object)strVal, (Object)servicePort.getName());
            }
        }
        return false;
    }

    private static String preparePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return "";
        }
        String ret = path;
        while (ret.startsWith("/")) {
            ret = ret.substring(1);
        }
        return ret;
    }

    private static ServicePort findServicePortByName(Service service, String portName) {
        if (StringUtils.isBlank((CharSequence)portName)) {
            return (ServicePort)service.getSpec().getPorts().iterator().next();
        }
        for (ServicePort servicePort : service.getSpec().getPorts()) {
            if (!Objects.equal((Object)servicePort.getName(), (Object)portName)) continue;
            return servicePort;
        }
        return null;
    }

    private static String serviceToHostOrBlank(String serviceName) {
        return ServiceUrlUtil.getEnvVarOrSystemProperty(ServiceUrlUtil.toServiceHostEnvironmentVariable(serviceName), "");
    }

    private static String serviceToProtocol(String serviceName, String servicePort) {
        return ServiceUrlUtil.getEnvVarOrSystemProperty(ServiceUrlUtil.toEnvVariable(serviceName + PORT_SUFFIX + "_" + servicePort + PROTO_SUFFIX), DEFAULT_PROTO);
    }

    private static String serviceToPortOrBlank(String serviceName) {
        String envVarName = ServiceUrlUtil.toServicePortEnvironmentVariable(serviceName);
        return ServiceUrlUtil.getEnvVarOrSystemProperty(envVarName, "");
    }

    private static String toServiceHostEnvironmentVariable(String serviceName) {
        return ServiceUrlUtil.toEnvVariable(serviceName + HOST_SUFFIX);
    }

    private static String toServicePortEnvironmentVariable(String serviceName) {
        String name = serviceName + PORT_SUFFIX;
        return ServiceUrlUtil.toEnvVariable(name);
    }

    private static String toEnvVariable(String serviceName) {
        return serviceName.toUpperCase().replaceAll("-", "_");
    }

    private static String getServiceHostAndPort(String serviceName, String defaultHost, String defaultPort) {
        String serviceEnvVarPrefix = ServiceUrlUtil.getServiceEnvVarPrefix(serviceName);
        String hostEnvVar = serviceEnvVarPrefix + "_HOST";
        String portEnvVar = serviceEnvVarPrefix + "_PORT";
        String host = ServiceUrlUtil.getEnvVarOrSystemProperty(hostEnvVar, hostEnvVar, defaultHost);
        String port = ServiceUrlUtil.getEnvVarOrSystemProperty(portEnvVar, portEnvVar, defaultPort);
        String answer = host + ":" + port;
        return answer;
    }

    private static String getServiceEnvVarPrefix(String serviceName) {
        return serviceName.toUpperCase().replace('-', '_') + "_SERVICE";
    }

    private static String getEnvVarOrSystemProperty(String envVarName, String systemProperty, String defaultValue) {
        String answer = null;
        answer = System.getenv(envVarName);
        if (StringUtils.isBlank((CharSequence)answer)) {
            answer = System.getProperty(systemProperty, defaultValue);
        }
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            return answer;
        }
        return defaultValue;
    }

    private static String getEnvVarOrSystemProperty(String envVarName, String defaultValue) {
        return ServiceUrlUtil.getEnvVarOrSystemProperty(envVarName, envVarName, defaultValue);
    }
}

