/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import com.google.common.base.Objects;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenUtil {
    private static final transient Logger LOG = LoggerFactory.getLogger(MavenUtil.class);
    private static final String DEFAULT_CONFIG_FILE_NAME = "kubernetes.json";

    public static boolean isKubernetesJsonArtifact(String classifier, String type) {
        return "json".equals(type) && "kubernetes".equals(classifier);
    }

    public static boolean hasKubernetesJson(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals(DEFAULT_CONFIG_FILE_NAME)) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }

    public static URLClassLoader getCompileClassLoader(MavenProject project) {
        try {
            List classpathElements = project.getCompileClasspathElements();
            return MavenUtil.createClassLoader(classpathElements, project.getBuild().getOutputDirectory());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalArgumentException("Cannot resolve artifact from compile classpath", e);
        }
    }

    public static URLClassLoader getTestClassLoader(MavenProject project) {
        try {
            List classpathElements = project.getTestClasspathElements();
            return MavenUtil.createClassLoader(classpathElements, project.getBuild().getTestOutputDirectory());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalArgumentException("Cannot resolve artifact from test classpath", e);
        }
    }

    public static String createDefaultResourceName(String artifactId, String ... suffixes) {
        String suffix = StringUtils.join((Object[])suffixes, (String)"-");
        String ret = artifactId + (suffix.length() > 0 ? "-" + suffix : "");
        if (ret.length() > 63) {
            ret = ret.substring(0, 63);
        }
        return ret.toLowerCase();
    }

    private static URLClassLoader createClassLoader(List<String> classpathElements, String ... paths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            URL url = MavenUtil.pathToUrl(path);
            urls.add(url);
        }
        for (Object e : classpathElements) {
            if (e == null) continue;
            String path = e.toString();
            URL url = MavenUtil.pathToUrl(path);
            urls.add(url);
        }
        return MavenUtil.createURLClassLoader(urls);
    }

    private static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    private static URL pathToUrl(String path) {
        try {
            File file = new File(path);
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to a an URL: %s", path, e.getMessage()), e);
        }
    }

    public static boolean hasDependency(MavenProject project, String groupId, String artifactId) {
        return MavenUtil.getDependencyVersion(project, groupId, artifactId) != null;
    }

    public static String getDependencyVersion(MavenProject project, String groupId, String artifactId) {
        Set artifacts = project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                String scope = artifact.getScope();
                if (Objects.equal((Object)"test", (Object)scope) || artifactId != null && !Objects.equal((Object)artifactId, (Object)artifact.getArtifactId()) || !Objects.equal((Object)groupId, (Object)artifact.getGroupId())) continue;
                return artifact.getVersion();
            }
        }
        return null;
    }

    public static boolean hasPlugin(MavenProject project, String groupId, String artifactId) {
        return project.getPlugin(groupId + ":" + artifactId) != null;
    }

    public static boolean hasPluginOfAnyGroupId(MavenProject project, String pluginArtifact) {
        return MavenUtil.getPluginOfAnyGroupId(project, pluginArtifact) != null;
    }

    public static Plugin getPluginOfAnyGroupId(MavenProject project, String pluginArtifact) {
        return MavenUtil.getPlugin(project, null, pluginArtifact);
    }

    public static Plugin getPlugin(MavenProject project, String groupId, String artifactId) {
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId cannot be null");
        }
        List plugins = project.getBuildPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                boolean matchesArtifactId = artifactId.equals(plugin.getArtifactId());
                boolean matchesGroupId = groupId == null || groupId.equals(plugin.getGroupId());
                if (!matchesGroupId || !matchesArtifactId) continue;
                return plugin;
            }
        }
        return null;
    }

    public static boolean hasResource(MavenProject project, String ... paths) {
        URLClassLoader compileClassLoader = MavenUtil.getCompileClassLoader(project);
        for (String path : paths) {
            try {
                if (compileClassLoader.getResource(path) == null) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static void createArchive(File sourceDir, File destinationFile, TarArchiver archiver) throws MojoExecutionException {
        try {
            archiver.setCompression(TarArchiver.TarCompressionMethod.gzip);
            archiver.setLongfile(TarLongFileMode.posix);
            archiver.addDirectory(sourceDir);
            archiver.setDestFile(destinationFile);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create archive " + destinationFile + ": " + e, (Exception)e);
        }
    }

    public static void createArchive(File sourceDir, File destinationFile, ZipArchiver archiver) throws MojoExecutionException {
        try {
            archiver.addDirectory(sourceDir);
            archiver.setDestFile(destinationFile);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create archive " + destinationFile + ": " + e, (Exception)e);
        }
    }

    public static String getVersion(String groupId, String artifactId) throws IOException {
        String path = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        InputStream in = MavenUtil.class.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            throw new IOException("Could not find " + path + " on classath!");
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            throw new IOException("Failed to load " + path + ". " + e, e);
        }
        String version = properties.getProperty("version");
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IOException("No version property in " + path);
        }
        return version;
    }

    public static Optional<List<String>> getCompileClasspathElementsIfRequested(MavenProject project, boolean useProjectClasspath) throws MojoExecutionException {
        if (!useProjectClasspath) {
            return Optional.empty();
        }
        try {
            return Optional.of(project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Cannot extra compile class path elements", (Exception)((Object)e));
        }
    }
}

