/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class MainClassDetector {
    private String mainClass = null;
    private final File classesDir;
    private final Logger log;

    public MainClassDetector(String mainClass, File classesDir, Logger log) {
        this.mainClass = mainClass;
        this.classesDir = classesDir;
        this.log = log;
    }

    public String getMainClass() throws MojoExecutionException {
        if (this.mainClass != null) {
            return this.mainClass;
        }
        try {
            List<String> foundMainClasses = ClassUtil.findMainClasses(this.classesDir);
            if (foundMainClasses.size() == 0) {
                this.mainClass = null;
                return null;
            }
            if (foundMainClasses.size() == 1) {
                this.mainClass = foundMainClasses.get(0);
                return this.mainClass;
            }
            this.log.warn("Found more than one main class : %s. Ignoring ....", new Object[]{foundMainClasses});
            this.mainClass = null;
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not examine main classes: " + e, e);
        }
    }
}

