/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.maven.core.util.kubernetes.KubernetesClientUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;

public class PodLogService {
    public static final String OPERATION_UNDEPLOY = "undeploy";
    public static final String OPERATION_STOP = "stop";
    private PodLogServiceContext context;
    private Logger log;
    private Watch podWatcher;
    private LogWatch logWatcher;
    private Map<String, Pod> addedPods = new ConcurrentHashMap<String, Pod>();
    private CountDownLatch terminateLatch = new CountDownLatch(1);
    private String watchingPodName;
    private String newestPodName;
    private CountDownLatch logWatchTerminateLatch;

    public PodLogService(PodLogServiceContext context) {
        this.context = context;
        this.log = context.getLog();
    }

    public void tailAppPodsLogs(final KubernetesClient kubernetes, final String namespace, final Set<HasMetadata> entities, boolean watchAddedPodsOnly, String onExitOperation, boolean followLog, Date ignorePodsOlderThan, boolean waitInCurrentThread) {
        LabelSelector selector = KubernetesResourceUtil.getPodLabelSelector(entities);
        if (selector != null) {
            String ctrlCMessage = "stop tailing the log";
            if (StringUtils.isNotBlank((CharSequence)onExitOperation)) {
                final String onExitOperationLower = onExitOperation.toLowerCase().trim();
                if (onExitOperationLower.equals(OPERATION_UNDEPLOY)) {
                    ctrlCMessage = "undeploy the app";
                } else if (onExitOperationLower.equals(OPERATION_STOP)) {
                    ctrlCMessage = "scale down the app and stop tailing the log";
                } else {
                    this.log.warn("Unknown on-exit command: `%s`", new Object[]{onExitOperationLower});
                }
                KubernetesClientUtil.resizeApp(kubernetes, namespace, entities, 1, this.log);
                Runtime.getRuntime().addShutdownHook(new Thread("pod log service shutdown hook"){

                    @Override
                    public void run() {
                        if (onExitOperationLower.equals(PodLogService.OPERATION_UNDEPLOY)) {
                            PodLogService.this.log.info("Undeploying the app:", new Object[0]);
                            KubernetesClientUtil.deleteEntities(kubernetes, namespace, entities, PodLogService.this.context.getS2iBuildNameSuffix(), PodLogService.this.log);
                        } else if (onExitOperationLower.equals(PodLogService.OPERATION_STOP)) {
                            PodLogService.this.log.info("Stopping the app:", new Object[0]);
                            KubernetesClientUtil.resizeApp(kubernetes, namespace, entities, 0, PodLogService.this.log);
                        }
                        if (PodLogService.this.podWatcher != null) {
                            PodLogService.this.podWatcher.close();
                        }
                        PodLogService.this.closeLogWatcher();
                    }
                });
            }
            this.waitAndLogPods(kubernetes, namespace, selector, watchAddedPodsOnly, ctrlCMessage, followLog, ignorePodsOlderThan, waitInCurrentThread);
        } else {
            this.log.warn("No selector in deployment so cannot watch pods!", new Object[0]);
        }
    }

    private void waitAndLogPods(final KubernetesClient kubernetes, final String namespace, LabelSelector selector, boolean watchAddedPodsOnly, final String ctrlCMessage, final boolean followLog, Date ignorePodsOlderThan, boolean waitInCurrentThread) {
        List items;
        FilterWatchListDeletable pods = KubernetesClientUtil.withSelector((NonNamespaceOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>>)((NonNamespaceOperation)kubernetes.pods().inNamespace(namespace)), selector, this.log);
        if (this.context.getPodName() != null) {
            this.log.info("Watching pod with selector %s, and name %s waiting for a running pod...", new Object[]{selector, this.context.getPodName()});
            pods = (FilterWatchListDeletable)pods.withField("metadata.name", this.context.getPodName());
        } else {
            this.log.info("Watching pods with selector %s waiting for a running pod...", new Object[]{selector});
        }
        Pod latestPod = null;
        boolean runningPod = false;
        PodList list = (PodList)pods.list();
        if (list != null && (items = list.getItems()) != null) {
            for (Pod pod : items) {
                if (!KubernetesHelper.isPodRunning(pod) && !KubernetesHelper.isPodWaiting(pod)) continue;
                if (latestPod == null || KubernetesResourceUtil.isNewerResource((HasMetadata)pod, latestPod)) {
                    if (ignorePodsOlderThan != null) {
                        Date podCreateTime = KubernetesResourceUtil.getCreationTimestamp((HasMetadata)pod);
                        if (podCreateTime != null && podCreateTime.compareTo(ignorePodsOlderThan) > 0) {
                            latestPod = pod;
                        }
                    } else {
                        latestPod = pod;
                    }
                }
                runningPod = true;
            }
        }
        if (latestPod != null) {
            this.onPod(Watcher.Action.ADDED, latestPod, kubernetes, namespace, ctrlCMessage, followLog);
        }
        if (!watchAddedPodsOnly && !runningPod) {
            this.log.warn("No pod is running yet. Are you sure you deployed your app via `fabric8:deploy`?", new Object[0]);
            this.log.warn("Or did you stop it via `fabric8:stop`? If so try running the `fabric8:start` goal", new Object[0]);
        }
        this.podWatcher = (Watch)pods.watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                PodLogService.this.onPod(action, pod, kubernetes, namespace, ctrlCMessage, followLog);
            }

            public void onClose(KubernetesClientException e) {
            }
        });
        if (waitInCurrentThread) {
            while (this.terminateLatch.getCount() > 0L) {
                try {
                    this.terminateLatch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void onPod(Watcher.Action action, Pod pod, KubernetesClient kubernetes, String namespace, String ctrlCMessage, boolean followLog) {
        Logger statusLog;
        String name = KubernetesHelper.getName((HasMetadata)pod);
        if (action.equals((Object)Watcher.Action.DELETED)) {
            this.addedPods.remove(name);
            if (Objects.equals(this.watchingPodName, name)) {
                this.watchingPodName = null;
                this.addedPods.remove(name);
            }
        } else if (action.equals((Object)Watcher.Action.ADDED) || action.equals((Object)Watcher.Action.MODIFIED)) {
            this.addedPods.put(name, pod);
        }
        Pod watchPod = KubernetesResourceUtil.getNewestPod(this.addedPods.values());
        this.newestPodName = KubernetesHelper.getName((HasMetadata)watchPod);
        Logger logger = statusLog = Objects.equals(name, this.newestPodName) ? this.context.getNewPodLog() : this.context.getOldPodLog();
        if (!action.equals((Object)Watcher.Action.MODIFIED) || this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            statusLog.info("%s status: %s%s", new Object[]{name, KubernetesClientUtil.getPodStatusDescription(pod), KubernetesClientUtil.getPodStatusMessagePostfix(action)});
        }
        if (watchPod != null && KubernetesHelper.isPodRunning(watchPod)) {
            this.watchLogOfPodName(kubernetes, namespace, ctrlCMessage, followLog, watchPod, KubernetesHelper.getName((HasMetadata)watchPod));
        }
    }

    private void watchLogOfPodName(KubernetesClient kubernetes, String namespace, String ctrlCMessage, boolean followLog, Pod pod, String name) {
        if (this.watchingPodName == null || !this.watchingPodName.equals(name)) {
            if (this.logWatcher != null) {
                this.log.info("Closing log watcher for %s as now watching %s", new Object[]{this.watchingPodName, name});
                this.closeLogWatcher();
            }
            PodResource podResource = (PodResource)((NonNamespaceOperation)kubernetes.pods().inNamespace(namespace)).withName(name);
            List<Container> containers = KubernetesHelper.getContainers(pod);
            String containerName = null;
            if (followLog) {
                this.watchingPodName = name;
                this.logWatchTerminateLatch = new CountDownLatch(1);
                if (containers.size() < 2) {
                    this.logWatcher = (LogWatch)podResource.watchLog();
                } else {
                    containerName = this.getLogContainerName(containers);
                    this.logWatcher = (LogWatch)((ContainerResource)podResource.inContainer((Object)containerName)).watchLog();
                }
                this.watchLog(this.logWatcher, name, "Failed to read log of pod " + name + ".", ctrlCMessage, containerName);
            } else {
                String logText;
                if (containers.size() < 2) {
                    logText = (String)podResource.getLog();
                } else {
                    containerName = this.getLogContainerName(containers);
                    logText = (String)((ContainerResource)podResource.inContainer((Object)containerName)).getLog();
                }
                if (logText != null) {
                    String[] lines = logText.split("\n");
                    this.log.info("Log of pod: %s%s", new Object[]{name, this.containerNameMessage(containerName)});
                    this.log.info("", new Object[0]);
                    for (String line : lines) {
                        this.log.info("[[s]]%s", new Object[]{line});
                    }
                }
                this.terminateLatch.countDown();
            }
        }
    }

    private String getLogContainerName(List<Container> containers) {
        if (StringUtils.isNotBlank((CharSequence)this.context.getLogContainerName())) {
            for (Container container : containers) {
                if (!Objects.equals(this.context.getLogContainerName(), container.getName())) continue;
                return this.context.getLogContainerName();
            }
            this.log.error("log container name %s does not exist in pod!! Did you set the correct value for property 'fabric8.log.container'", new Object[]{this.context.getLogContainerName()});
        }
        return containers.get(0).getName();
    }

    private void closeLogWatcher() {
        if (this.logWatcher != null) {
            this.logWatcher.close();
            this.logWatcher = null;
        }
        if (this.logWatchTerminateLatch != null) {
            this.logWatchTerminateLatch.countDown();
        }
    }

    private void watchLog(LogWatch logWatcher, String podName, String failureMessage, String ctrlCMessage, String containerName) {
        this.context.getNewPodLog().info("Tailing log of pod: " + podName + this.containerNameMessage(containerName), new Object[0]);
        this.context.getNewPodLog().info("Press Ctrl-C to " + ctrlCMessage, new Object[0]);
        this.context.getNewPodLog().info("", new Object[0]);
        KubernetesClientUtil.printLogsAsync(logWatcher, failureMessage, this.logWatchTerminateLatch, this.log);
    }

    private String containerNameMessage(String containerName) {
        if (StringUtils.isNotBlank((CharSequence)containerName)) {
            return " container: " + containerName;
        }
        return "";
    }

    public static class PodLogServiceContext {
        private Logger log;
        private Logger newPodLog;
        private Logger oldPodLog;
        private String logContainerName;
        private String podName;
        private String s2iBuildNameSuffix = "-s2i";

        public Logger getLog() {
            return this.log;
        }

        public Logger getNewPodLog() {
            return this.newPodLog;
        }

        public Logger getOldPodLog() {
            return this.oldPodLog;
        }

        public String getLogContainerName() {
            return this.logContainerName;
        }

        public String getPodName() {
            return this.podName;
        }

        public String getS2iBuildNameSuffix() {
            return this.s2iBuildNameSuffix;
        }

        public static class Builder {
            private PodLogServiceContext context;

            public Builder() {
                this.context = new PodLogServiceContext();
            }

            public Builder(PodLogServiceContext context) {
                this.context = context;
            }

            public Builder log(Logger log) {
                this.context.log = log;
                return this;
            }

            public Builder newPodLog(Logger newPodLog) {
                this.context.newPodLog = newPodLog;
                return this;
            }

            public Builder oldPodLog(Logger oldPodLog) {
                this.context.oldPodLog = oldPodLog;
                return this;
            }

            public Builder logContainerName(String logContainerName) {
                this.context.logContainerName = logContainerName;
                return this;
            }

            public Builder podName(String podName) {
                this.context.podName = podName;
                return this;
            }

            public Builder s2iBuildNameSuffix(String s2iBuildNameSuffix) {
                this.context.s2iBuildNameSuffix = s2iBuildNameSuffix;
                return this;
            }

            public PodLogServiceContext build() {
                return this.context;
            }
        }
    }
}

