/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.service.ApplyService;
import io.fabric8.maven.core.service.ArtifactResolverService;
import io.fabric8.maven.core.service.ArtifactResolverServiceMavenImpl;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.kubernetes.DockerBuildService;
import io.fabric8.maven.core.service.kubernetes.JibBuildService;
import io.fabric8.maven.core.service.openshift.OpenshiftBuildService;
import io.fabric8.maven.core.util.LazyBuilder;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

public class Fabric8ServiceHub {
    private ClusterAccess clusterAccess;
    private RuntimeMode platformMode;
    private Logger log;
    private ServiceHub dockerServiceHub;
    private BuildService.BuildServiceConfig buildServiceConfig;
    private RepositorySystem repositorySystem;
    private MavenProject mavenProject;
    private boolean isJib;
    private RuntimeMode resolvedMode;
    private KubernetesClient client;
    private ConcurrentHashMap<Class<?>, LazyBuilder<?>> services = new ConcurrentHashMap();

    private Fabric8ServiceHub() {
    }

    private void init() {
        Objects.requireNonNull(this.clusterAccess, "clusterAccess");
        Objects.requireNonNull(this.log, "log");
        this.resolvedMode = this.clusterAccess.resolveRuntimeMode(this.platformMode, this.log);
        if (this.resolvedMode != RuntimeMode.kubernetes && this.resolvedMode != RuntimeMode.openshift) {
            throw new IllegalArgumentException("Unknown platform mode " + (Object)((Object)this.platformMode) + " resolved as " + (Object)((Object)this.resolvedMode));
        }
        this.client = this.clusterAccess.createDefaultClient(this.log);
        this.services.putIfAbsent(ApplyService.class, new LazyBuilder<ApplyService>(){

            @Override
            protected ApplyService build() {
                return new ApplyService(Fabric8ServiceHub.this.client, Fabric8ServiceHub.this.log);
            }
        });
        this.services.putIfAbsent(BuildService.class, new LazyBuilder<BuildService>(){

            @Override
            protected BuildService build() {
                BuildService buildService;
                if (Fabric8ServiceHub.this.resolvedMode == RuntimeMode.openshift) {
                    if (!(Fabric8ServiceHub.this.client instanceof OpenShiftClient)) {
                        throw new IllegalStateException("Openshift platform has been specified but Openshift has not been detected!");
                    }
                    buildService = new OpenshiftBuildService((OpenShiftClient)Fabric8ServiceHub.this.client, Fabric8ServiceHub.this.log, Fabric8ServiceHub.this.dockerServiceHub, Fabric8ServiceHub.this.buildServiceConfig);
                } else {
                    buildService = Fabric8ServiceHub.this.isJib ? new JibBuildService(Fabric8ServiceHub.this.buildServiceConfig, Fabric8ServiceHub.this.log) : new DockerBuildService(Fabric8ServiceHub.this.dockerServiceHub, Fabric8ServiceHub.this.buildServiceConfig);
                }
                return buildService;
            }
        });
        this.services.putIfAbsent(ArtifactResolverService.class, new LazyBuilder<ArtifactResolverService>(){

            @Override
            protected ArtifactResolverService build() {
                return new ArtifactResolverServiceMavenImpl(Fabric8ServiceHub.this.repositorySystem, Fabric8ServiceHub.this.mavenProject);
            }
        });
    }

    public BuildService getBuildService() {
        return (BuildService)this.services.get(BuildService.class).get();
    }

    public ArtifactResolverService getArtifactResolverService() {
        return (ArtifactResolverService)this.services.get(ArtifactResolverService.class).get();
    }

    public static class Builder {
        private Fabric8ServiceHub hub = new Fabric8ServiceHub();

        public Builder clusterAccess(ClusterAccess clusterAccess) {
            this.hub.clusterAccess = clusterAccess;
            return this;
        }

        public Builder platformMode(RuntimeMode platformMode) {
            this.hub.platformMode = platformMode;
            return this;
        }

        public Builder log(Logger log) {
            this.hub.log = log;
            return this;
        }

        public Builder isJibMode(boolean isJib) {
            this.hub.isJib = isJib;
            return this;
        }

        public Builder dockerServiceHub(ServiceHub dockerServiceHub) {
            this.hub.dockerServiceHub = dockerServiceHub;
            return this;
        }

        public Builder buildServiceConfig(BuildService.BuildServiceConfig buildServiceConfig) {
            this.hub.buildServiceConfig = buildServiceConfig;
            return this;
        }

        public Builder repositorySystem(RepositorySystem repositorySystem) {
            this.hub.repositorySystem = repositorySystem;
            return this;
        }

        public Builder mavenProject(MavenProject mavenProject) {
            this.hub.mavenProject = mavenProject;
            return this;
        }

        public Fabric8ServiceHub build() {
            this.hub.init();
            return this.hub;
        }
    }
}

