/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import io.fabric8.maven.core.config.ServiceProtocol;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class ServiceConfig {
    @Parameter
    private String name;
    @Parameter
    List<Port> ports;
    @Parameter
    private boolean headless = false;
    @Parameter
    private boolean expose = false;
    @Parameter
    private boolean normalizePort = false;
    @Parameter
    private String type;

    public String getName() {
        return this.name;
    }

    public List<Port> getPorts() {
        return this.ports != null ? this.ports : Collections.emptyList();
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public boolean isExpose() {
        return this.expose;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNormalizePort() {
        return this.normalizePort;
    }

    public static class Port {
        @Parameter
        String protocol;
        @Parameter
        int port;
        @Parameter
        int targetPort;
        @Parameter
        Integer nodePort;
        @Parameter
        String name;

        public ServiceProtocol getProtocol() {
            return this.protocol != null ? ServiceProtocol.valueOf(this.protocol.toUpperCase()) : null;
        }

        public int getPort() {
            return this.port;
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public Integer getNodePort() {
            return this.nodePort;
        }

        public String getName() {
            return this.name;
        }

        public static class Builder {
            Port config = new Port();

            public static Builder from(Port port) {
                Builder ret = new Builder();
                ret.config = port;
                return ret;
            }

            public Builder name(String name) {
                this.config.name = name;
                return this;
            }

            public Builder protocol(ServiceProtocol protocol) {
                this.config.protocol = protocol != null ? protocol.name() : null;
                return this;
            }

            public Builder protocol(String protocol) {
                this.config.protocol = protocol;
                return this;
            }

            public Builder port(int port) {
                this.config.port = port;
                return this;
            }

            public Builder targetPort(int targetPort) {
                this.config.targetPort = targetPort;
                return this;
            }

            public Builder nodePort(Integer nodePort) {
                this.config.nodePort = nodePort;
                return this;
            }

            public Port build() {
                return this.config;
            }
        }
    }

    public static class Builder {
        private ServiceConfig config = new ServiceConfig();

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder ports(List<Port> ports) {
            this.config.ports = ports;
            return this;
        }

        public Builder headless(boolean headless) {
            this.config.headless = headless;
            return this;
        }

        public Builder expose(boolean expose) {
            this.config.expose = expose;
            return this;
        }

        public Builder type(String type) {
            this.config.type = type;
            return this;
        }

        public Builder normalizePort(boolean normalize) {
            this.config.normalizePort = normalize;
            return this;
        }

        public ServiceConfig build() {
            return this.config;
        }
    }
}

