/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.YamlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootUtil {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringBootUtil.class);

    public static Properties getSpringBootApplicationProperties(URLClassLoader compileClassLoader) {
        URL ymlResource = compileClassLoader.findResource("application.yml");
        URL propertiesResource = compileClassLoader.findResource("application.properties");
        Properties props = YamlUtil.getPropertiesFromYamlResource(ymlResource);
        props.putAll((Map<?, ?>)SpringBootUtil.getPropertiesResource(propertiesResource));
        return props;
    }

    protected static Properties getPropertiesResource(URL resource) {
        Properties answer = new Properties();
        if (resource != null) {
            try (InputStream stream = resource.openStream();){
                answer.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading resource from URL " + resource, e);
            }
        }
        return answer;
    }

    public static Optional<String> getSpringBootDevToolsVersion(MavenProject mavenProject) {
        return SpringBootUtil.getSpringBootVersion(mavenProject);
    }

    public static Optional<String> getSpringBootVersion(MavenProject mavenProject) {
        return Optional.ofNullable(MavenUtil.getDependencyVersion(mavenProject, "org.springframework.boot", "spring-boot"));
    }
}

