/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.gson.JsonObject;
import io.fabric8.maven.core.util.ResourceFileType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;

public class ResourceUtil {
    public static boolean jsonEquals(JsonObject first, JsonObject second) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode tree1 = mapper.readTree(first.toString());
            JsonNode tree2 = mapper.readTree(second.toString());
            return tree1.equals((Object)tree2);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static <T> T load(File file, Class<T> clazz) throws IOException {
        ResourceFileType type = ResourceFileType.fromFile(file);
        return ResourceUtil.load(file, clazz, type);
    }

    public static <T> T load(File file, Class<T> clazz, ResourceFileType resourceFileType) throws IOException {
        return (T)ResourceUtil.getObjectMapper(resourceFileType).readValue(file, clazz);
    }

    public static <T> T load(InputStream in, Class<T> clazz, ResourceFileType resourceFileType) throws IOException {
        return (T)ResourceUtil.getObjectMapper(resourceFileType).readValue(in, clazz);
    }

    public static File save(File file, Object data) throws IOException {
        return ResourceUtil.save(file, data, ResourceFileType.fromFile(file));
    }

    public static File save(File file, Object data, ResourceFileType type) throws IOException {
        boolean hasExtension = FilenameUtils.indexOfExtension((String)file.getAbsolutePath()) != -1;
        File output = hasExtension ? file : type.addExtensionIfMissing(file);
        ResourceUtil.ensureDir(file);
        ResourceUtil.getObjectMapper(type).writeValue(output, data);
        return output;
    }

    public static String toYaml(Object resource) throws JsonProcessingException {
        return ResourceUtil.serializeAsString(resource, ResourceFileType.yaml);
    }

    public static String toJson(Object resource) throws JsonProcessingException {
        return ResourceUtil.serializeAsString(resource, ResourceFileType.json);
    }

    private static String serializeAsString(Object resource, ResourceFileType resourceFileType) throws JsonProcessingException {
        return ResourceUtil.getObjectMapper(resourceFileType).writeValueAsString(resource);
    }

    private static ObjectMapper getObjectMapper(ResourceFileType resourceFileType) {
        if (resourceFileType == ResourceFileType.yaml) {
            return new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.MINIMIZE_QUOTES)).enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        }
        return resourceFileType.getObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
    }

    private static void ensureDir(File file) throws IOException {
        File parentDir = file.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Cannot create directory " + parentDir);
        }
    }
}

