/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.Port;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.kubernetes.JibBuildService;
import io.fabric8.maven.core.util.FatJarDetector;
import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.maven.plugin.MojoExecutionException;

public class JibBuildServiceUtil {
    private static final String DEFAULT_JAR_NAME = "/app.jar";
    private static final String DEFAULT_USER_NAME = "fabric8/";

    private JibBuildServiceUtil() {
    }

    public static void buildImage(JibBuildService.JibBuildConfiguration buildConfiguration, Logger log) throws InvalidImageReferenceException {
        String fromImage = buildConfiguration.getFrom();
        String targetImage = buildConfiguration.getTargetImage();
        Credential credential = buildConfiguration.getCredential();
        Map<String, String> envMap = buildConfiguration.getEnvMap();
        List<String> portList = buildConfiguration.getPorts();
        Set<Port> portSet = JibBuildServiceUtil.getPortSet(portList);
        String outputDir = buildConfiguration.getOutputDir();
        String targetDir = buildConfiguration.getTargetDir();
        Path fatJar = buildConfiguration.getFatJar();
        ArrayList<String> entrypointList = new ArrayList();
        if (buildConfiguration.getEntryPoint() != null) {
            entrypointList = buildConfiguration.getEntryPoint().asStrings();
        }
        JibBuildServiceUtil.buildImage(fromImage, targetImage, envMap, credential, portSet, fatJar, entrypointList, targetDir, outputDir, log);
    }

    protected static JibContainer buildImage(String baseImage, String targetImage, Map<String, String> envMap, Credential credential, Set<Port> portSet, Path fatJar, List<String> entrypointList, String targetDir, String outputDir, Logger log) throws InvalidImageReferenceException {
        String username = "";
        String password = "";
        JibContainerBuilder contBuild = Jib.from((String)baseImage);
        if (envMap != null) {
            contBuild = contBuild.setEnvironment(envMap);
        }
        if (portSet != null) {
            contBuild = contBuild.setExposedPorts(portSet);
        }
        if (fatJar != null) {
            String fatJarName = fatJar.getFileName().toString();
            String jarPath = targetDir + "/" + (fatJarName.isEmpty() ? DEFAULT_JAR_NAME : fatJarName);
            contBuild = contBuild.addLayer(LayerConfiguration.builder().addEntry(fatJar, AbsoluteUnixPath.get((String)jarPath)).build());
        }
        if (!entrypointList.isEmpty()) {
            contBuild = contBuild.setEntrypoint(entrypointList);
        }
        if (credential != null) {
            username = credential.getUsername();
            password = credential.getPassword();
            if (targetImage.contains(DEFAULT_USER_NAME)) {
                targetImage = targetImage.replaceFirst(DEFAULT_USER_NAME, username + "/");
            }
        }
        RegistryImage registryImage = RegistryImage.named((String)targetImage).addCredential(username, password);
        String imageTarName = ImageReference.parse((String)targetImage).getRepository().concat(".tar");
        TarImage tarImage = TarImage.named((String)targetImage).saveTo(Paths.get(outputDir + "/" + imageTarName, new String[0]));
        try {
            JibContainer jibContainer = JibBuildServiceUtil.buildContainer(contBuild, registryImage, log);
            log.info("Image %s successfully built and pushed.", new Object[]{targetImage});
            return jibContainer;
        }
        catch (RegistryException re) {
            log.warn("Registry Exception occureed : %s", new Object[]{re.getMessage()});
            log.warn("Credentials are probably either not configured or are incorrect.", new Object[0]);
            log.info("Building Image Tarball at %s.", new Object[]{imageTarName});
            JibContainer jibContainer = JibBuildServiceUtil.buildContainer(contBuild, tarImage, log, false);
            log.info(" %s successfully built.", new Object[]{Paths.get(outputDir + "/" + imageTarName, new String[0])});
            return jibContainer;
        }
        catch (ExecutionException e) {
            log.warn("Can't connect to the remote registry host: %s", new Object[]{e.getMessage()});
            JibContainer jibContainer = JibBuildServiceUtil.buildContainer(contBuild, tarImage, log, true);
            log.info("%s successfully built.", new Object[]{Paths.get(outputDir + "/" + imageTarName, new String[0])});
            return jibContainer;
        }
    }

    public static JibContainer buildContainer(JibContainerBuilder jibContainerBuilder, TarImage image, Logger logger, boolean offline) {
        try {
            if (offline) {
                logger.info("Trying to build the image tarball in the offline mode.", new Object[0]);
            }
            return jibContainerBuilder.containerize(Containerizer.to((TarImage)image).setOfflineMode(offline));
        }
        catch (CacheDirectoryCreationException | RegistryException | IOException | InterruptedException | ExecutionException ex) {
            logger.error("Unable to build the image tarball: %s", new Object[]{ex.getMessage()});
            throw new IllegalStateException(ex);
        }
    }

    public static JibContainer buildContainer(JibContainerBuilder jibContainerBuilder, RegistryImage image, Logger logger) throws RegistryException, ExecutionException {
        try {
            return jibContainerBuilder.containerize(Containerizer.to((RegistryImage)image));
        }
        catch (CacheDirectoryCreationException | IOException | InterruptedException e) {
            logger.error("Unable to build the image in the offline mode: %s", new Object[]{e.getMessage()});
            throw new IllegalStateException(e);
        }
    }

    public static JibBuildService.JibBuildConfiguration getJibBuildConfiguration(BuildService.BuildServiceConfig config, BuildImageConfiguration buildImageConfiguration, String fullImageName, Logger log) throws MojoExecutionException {
        BuildService.BuildContext dockerBuildContext = config.getDockerBuildContext();
        RegistryService.RegistryConfig registryConfig = dockerBuildContext.getRegistryConfig();
        String targetDir = buildImageConfiguration.getAssemblyConfiguration().getTargetDir();
        MojoParameters mojoParameters = config.getDockerMojoParameters();
        String outputDir = mojoParameters.getOutputDirectory();
        if (targetDir == null) {
            targetDir = "/deployments";
        }
        AuthConfig authConfig = registryConfig.getAuthConfigFactory().createAuthConfig(true, true, registryConfig.getAuthConfig(), registryConfig.getSettings(), null, registryConfig.getRegistry());
        JibBuildService.JibBuildConfiguration.Builder jibBuildConfigurationBuilder = new JibBuildService.JibBuildConfiguration.Builder(log).from(buildImageConfiguration.getFrom()).envMap(buildImageConfiguration.getEnv()).ports(buildImageConfiguration.getPorts()).entrypoint(buildImageConfiguration.getEntryPoint()).targetImage(fullImageName).targetDir(targetDir).outputDir(outputDir).buildDirectory(config.getBuildDirectory());
        if (authConfig != null) {
            jibBuildConfigurationBuilder.credential(Credential.from((String)authConfig.getUsername(), (String)authConfig.getPassword()));
        }
        return jibBuildConfigurationBuilder.build();
    }

    private static Set<Port> getPortSet(List<String> ports) {
        HashSet<Port> portSet = new HashSet<Port>();
        for (String port : ports) {
            portSet.add(Port.tcp((int)Integer.parseInt(port)));
        }
        return portSet;
    }

    public static Path getFatJar(String buildDir, Logger log) {
        FatJarDetector fatJarDetector = new FatJarDetector(buildDir);
        try {
            FatJarDetector.Result result = fatJarDetector.scan();
            if (result != null) {
                return result.getArchiveFile().toPath();
            }
        }
        catch (MojoExecutionException e) {
            log.error("MOJO Execution exception occurred: %s", new Object[]{e});
            throw new UnsupportedOperationException();
        }
        return null;
    }
}

