/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsciiDocParser {
    private static final String END_TABLE = "|===";

    public Map<String, List<String>> serializeKindFilenameTable(InputStream table) {
        HashMap<String, List<String>> serializedContent = new HashMap<String, List<String>>();
        try (BufferedReader tableContent = new BufferedReader(new InputStreamReader(table));){
            this.skipUntilColumns(tableContent);
            boolean endTable = false;
            while (!endTable) {
                List<String> readRow = this.readRow(tableContent);
                String separator = this.readEmptyLineOrEndTable(tableContent);
                String kind = readRow.get(0);
                serializedContent.put(kind, readRow.subList(1, readRow.size()));
                if (!END_TABLE.equals(separator)) continue;
                endTable = true;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return serializedContent;
    }

    private List<String> readRow(BufferedReader tableContent) throws IOException {
        String[] filenameTypes;
        ArrayList<String> content = new ArrayList<String>();
        String firstColumn = this.readColumn(tableContent);
        String secondColumn = this.readColumn(tableContent);
        content.add(firstColumn);
        for (String filenameType : filenameTypes = secondColumn.split(",")) {
            content.add(filenameType.trim());
        }
        return content;
    }

    private String readColumn(BufferedReader tableContent) throws IOException {
        String column = tableContent.readLine();
        if (column == null || column.isEmpty()) {
            throw new IllegalArgumentException("Trying to read a column but white line or EOF was found.");
        }
        int separator = column.indexOf("|");
        if (separator < 0) {
            throw new IllegalArgumentException(String.format("Expected the initial of a column with (|) but %s found.", column));
        }
        return column.trim().substring(separator + 1).replaceAll("[`_*]", "").trim();
    }

    private String readEmptyLineOrEndTable(BufferedReader tableContent) throws IOException {
        String column = tableContent.readLine();
        if (column != null && column.startsWith(END_TABLE)) {
            return END_TABLE;
        }
        if (column == null || !column.isEmpty()) {
            throw new IllegalArgumentException(String.format("Trying to read an empty line for end of row, but content %s was found or EOF", column));
        }
        return "";
    }

    private void skipUntilColumns(BufferedReader tableContent) throws IOException {
        String line;
        while ((line = tableContent.readLine()) != null && !line.trim().isEmpty()) {
        }
    }
}

