/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.kubernetes;

import com.google.cloud.tools.jib.api.Credential;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.util.JibBuildServiceUtil;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.DeepCopy;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JibBuildService
implements BuildService {
    private BuildService.BuildServiceConfig config;
    private Logger log;

    private JibBuildService() {
    }

    public JibBuildService(BuildService.BuildServiceConfig config, Logger log) {
        Objects.requireNonNull(config, "config");
        this.config = config;
        this.log = log;
    }

    @Override
    public void build(ImageConfiguration imageConfiguration) {
        try {
            BuildImageConfiguration buildImageConfiguration = imageConfiguration.getBuildConfiguration();
            List tags = buildImageConfiguration.getTags();
            String fullName = "";
            if (tags.size() > 0) {
                for (String tag : tags) {
                    if (tag == null) continue;
                    fullName = new ImageName(imageConfiguration.getName(), tag).getFullName();
                }
            } else {
                fullName = new ImageName(imageConfiguration.getName(), null).getFullName();
            }
            this.log.info("Image tagging successfull!", new Object[0]);
            JibBuildConfiguration jibBuildConfiguration = JibBuildServiceUtil.getJibBuildConfiguration(this.config, buildImageConfiguration, fullName, this.log);
            JibBuildServiceUtil.buildImage(jibBuildConfiguration, this.log);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void postProcess(BuildService.BuildServiceConfig config) {
    }

    public static class JibBuildConfiguration {
        private Map<String, String> envMap;
        private Credential credential;
        private List<String> ports;
        private String from;
        private String target;
        private Path fatJarPath;
        private Arguments entrypoint;
        private String targetDir;
        private String outputDir;

        private JibBuildConfiguration() {
        }

        public Arguments getEntryPoint() {
            return this.entrypoint;
        }

        public String getTargetDir() {
            return this.targetDir;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public Map<String, String> getEnvMap() {
            return this.envMap;
        }

        public Credential getCredential() {
            return this.credential;
        }

        public List<String> getPorts() {
            return this.ports;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTargetImage() {
            return this.target;
        }

        public Path getFatJar() {
            return this.fatJarPath;
        }

        public static class Builder {
            private final JibBuildConfiguration configutil;
            private final Logger logger;

            public Builder(Logger logger) {
                this(null, logger);
            }

            public Builder(JibBuildConfiguration that, Logger logger) {
                this.logger = logger;
                this.configutil = that == null ? new JibBuildConfiguration() : (JibBuildConfiguration)DeepCopy.copy((Object)that);
            }

            public Builder envMap(Map<String, String> envMap) {
                this.configutil.envMap = envMap;
                return this;
            }

            public Builder credential(Credential credential) {
                this.configutil.credential = credential;
                return this;
            }

            public Builder ports(List<String> ports) {
                this.configutil.ports = ports;
                return this;
            }

            public Builder from(String from) {
                this.configutil.from = from;
                return this;
            }

            public Builder targetImage(String imageName) {
                this.configutil.target = imageName;
                return this;
            }

            public Builder entrypoint(Arguments entrypoint) {
                this.configutil.entrypoint = entrypoint;
                return this;
            }

            public Builder buildDirectory(String buildDir) {
                this.configutil.fatJarPath = JibBuildServiceUtil.getFatJar(buildDir, this.logger);
                return this;
            }

            public Builder targetDir(String targetDir) {
                this.configutil.targetDir = targetDir;
                return this;
            }

            public Builder outputDir(String outputDir) {
                this.configutil.outputDir = outputDir;
                return this;
            }

            public JibBuildConfiguration build() {
                return this.configutil;
            }
        }
    }
}

