/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.List;

public class StatefulSetHandler {
    private final PodTemplateHandler podTemplateHandler;

    StatefulSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public StatefulSet getStatefulSet(ResourceConfig config, List<ImageConfiguration> images) {
        return ((StatefulSetBuilder)((StatefulSetBuilder)new StatefulSetBuilder().withMetadata(this.createStatefulSetMetaData(config))).withSpec(this.createStatefulSetSpec(config, images))).build();
    }

    private ObjectMeta createStatefulSetMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId(config.getControllerName(), "controller name"))).build();
    }

    private StatefulSetSpec createStatefulSetSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)((StatefulSetSpecBuilder)new StatefulSetSpecBuilder().withReplicas(Integer.valueOf(config.getReplicas()))).withServiceName(config.getControllerName())).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

