/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.VolumeConfig;
import io.fabric8.maven.core.config.VolumeType;
import io.fabric8.maven.core.handler.ContainerHandler;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.ArrayList;
import java.util.List;

public class PodTemplateHandler {
    private final ContainerHandler containerHandler;

    PodTemplateHandler(ContainerHandler containerHandler) {
        this.containerHandler = containerHandler;
    }

    public PodTemplateSpec getPodTemplate(ResourceConfig config, List<ImageConfiguration> images) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(this.createPodMetaData(config))).withSpec(this.createPodSpec(config, images))).build();
    }

    private ObjectMeta createPodMetaData(ResourceConfig config) {
        return new ObjectMetaBuilder().build();
    }

    private PodSpec createPodSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withServiceAccountName(config.getServiceAccount())).withContainers(this.containerHandler.getContainers(config, images))).withVolumes(this.getVolumes(config))).build();
    }

    private List<Volume> getVolumes(ResourceConfig config) {
        List<VolumeConfig> volumeConfigs = config.getVolumes();
        ArrayList<Volume> ret = new ArrayList<Volume>();
        if (volumeConfigs != null) {
            for (VolumeConfig volumeConfig : volumeConfigs) {
                VolumeType type = VolumeType.typeFor(volumeConfig.getType());
                if (type == null) continue;
                ret.add(type.fromConfig(volumeConfig));
            }
        }
        return ret;
    }
}

