/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.maven.core.config.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;

public class ProcessorConfig {
    public static final ProcessorConfig EMPTY = new ProcessorConfig();
    @JsonProperty(value="includes")
    @Parameter
    List<String> includes = new ArrayList<String>();
    @JsonProperty(value="excludes")
    @Parameter
    Set<String> excludes = new HashSet<String>();
    @JsonProperty(value="config")
    @Parameter
    Map<String, TreeMap> config = new HashMap<String, TreeMap>();

    public ProcessorConfig() {
    }

    public ProcessorConfig(List<String> includes, Set<String> excludes, Map<String, TreeMap> config) {
        this.includes = includes != null ? includes : Collections.emptyList();
        Set<String> set = this.excludes = excludes != null ? excludes : Collections.emptySet();
        if (config != null) {
            this.config = config;
        }
    }

    public String getConfig(String name, String key) {
        TreeMap processorMap = this.config.get(name);
        return processorMap != null ? (String)processorMap.get(key) : null;
    }

    public Map<String, String> getConfigMap(String name) {
        return this.config.containsKey(name) ? Collections.unmodifiableMap(this.config.get(name)) : Collections.emptyMap();
    }

    public <T extends Named> List<T> prepareProcessors(List<T> namedList, String type) {
        ArrayList<Named> ret = new ArrayList<Named>();
        HashMap<String, Named> lookup = new HashMap<String, Named>();
        for (Named named : namedList) {
            lookup.put(named.getName(), named);
        }
        for (String inc : this.includes) {
            if (!this.use(inc)) continue;
            Named named = (Named)lookup.get(inc);
            if (named == null) {
                ArrayList keys = new ArrayList(lookup.keySet());
                Collections.sort(keys);
                throw new IllegalArgumentException("No " + type + " with name '" + inc + "' found to include. Please check spelling in your profile / config and your project dependencies. Included " + type + "s: " + StringUtils.join(keys, (String)", "));
            }
            ret.add(named);
        }
        return ret;
    }

    public boolean use(String inc) {
        return !this.excludes.contains(inc) && this.includes.contains(inc);
    }

    public static ProcessorConfig cloneProcessorConfig(ProcessorConfig processorConfig) {
        return ProcessorConfig.mergeProcessorConfigs(processorConfig);
    }

    public static ProcessorConfig mergeProcessorConfigs(ProcessorConfig ... processorConfigs) {
        Map<String, TreeMap> configs = ProcessorConfig.mergeConfig(processorConfigs);
        Set<String> excludes = ProcessorConfig.mergeExcludes(processorConfigs);
        List<String> includes = ProcessorConfig.mergeIncludes(processorConfigs);
        return new ProcessorConfig(includes, excludes, configs);
    }

    private static Set<String> mergeExcludes(ProcessorConfig ... configs) {
        HashSet<String> ret = new HashSet<String>();
        for (ProcessorConfig config : configs) {
            Set<String> excludes;
            if (config == null || (excludes = config.excludes) == null) continue;
            ret.addAll(excludes);
        }
        return ret;
    }

    private static List<String> mergeIncludes(ProcessorConfig ... configs) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ProcessorConfig config : configs) {
            List<String> includes;
            if (config == null || (includes = config.includes) == null) continue;
            ret.addAll(includes);
        }
        return ProcessorConfig.removeDups(ret);
    }

    private static List<String> removeDups(List<String> list) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String el : list) {
            if (ret.contains(el)) continue;
            ret.add(el);
        }
        return ret;
    }

    private static Map<String, TreeMap> mergeConfig(ProcessorConfig ... processorConfigs) {
        HashMap<String, TreeMap> ret = new HashMap<String, TreeMap>();
        if (processorConfigs.length > 0) {
            for (int i = processorConfigs.length - 1; i >= 0; --i) {
                Map<String, TreeMap> config;
                ProcessorConfig processorConfig = processorConfigs[i];
                if (processorConfig == null || (config = processorConfig.config) == null) continue;
                for (Map.Entry<String, TreeMap> entry : config.entrySet()) {
                    TreeMap newValues = entry.getValue();
                    if (newValues == null) continue;
                    TreeMap existing = (TreeMap)ret.get(entry.getKey());
                    if (existing == null) {
                        ret.put(entry.getKey(), new TreeMap(newValues));
                        continue;
                    }
                    for (Map.Entry newValue : newValues.entrySet()) {
                        existing.put(newValue.getKey(), newValue.getValue());
                    }
                }
            }
        }
        return ret.size() > 0 ? ret : null;
    }
}

