/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.vertx;

import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.javaexec.JavaExecGenerator;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class VertxGenerator
extends JavaExecGenerator {
    private static final String VERTX_MAVEN_PLUGIN_GA = "io.fabric8:vertx-maven-plugin";
    private static final String SHADE_PLUGIN_GA = "org.apache.maven.plugins:maven-shade-plugin";
    private static final String VERTX_GROUPID = "io.vertx";

    public VertxGenerator(GeneratorContext context) {
        super(context, "vertx");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) throws MojoExecutionException {
        return this.shouldAddImageConfiguration(configs) && (MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)VERTX_MAVEN_PLUGIN_GA) || MavenUtil.hasDependency((MavenProject)this.getProject(), (String)VERTX_GROUPID));
    }

    protected List<String> getExtraJavaOptions() {
        List opts = super.getExtraJavaOptions();
        opts.add("-Dvertx.cacheDirBase=/tmp");
        return opts;
    }

    protected boolean isFatJar() throws MojoExecutionException {
        return !this.hasMainClass() && this.isUsingFatJarPlugin() || super.isFatJar();
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean isPrePackagePhase) throws MojoExecutionException {
        return super.customize(configs, isPrePackagePhase);
    }

    private boolean isUsingFatJarPlugin() {
        MavenProject project = this.getProject();
        Plugin shade = project.getPlugin(SHADE_PLUGIN_GA);
        Plugin vertx = project.getPlugin(VERTX_MAVEN_PLUGIN_GA);
        return shade != null || vertx != null;
    }
}

