/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.vertx;

import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.javaexec.JavaExecGenerator;
import io.fabric8.maven.generator.vertx.VertxPortsExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class VertxGenerator
extends JavaExecGenerator {
    public VertxGenerator(GeneratorContext context) {
        super(context, "vertx");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) throws MojoExecutionException {
        return this.shouldAddImageConfiguration(configs) && (MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)"io.fabric8:vertx-maven-plugin") || MavenUtil.hasDependencyOnAnyArtifactOfGroup((MavenProject)this.getProject(), (String)"io.vertx"));
    }

    protected List<String> getExtraJavaOptions() {
        List opts = super.getExtraJavaOptions();
        opts.add("-Dvertx.cacheDirBase=/tmp");
        return opts;
    }

    protected boolean isFatJar() throws MojoExecutionException {
        return !this.hasMainClass() && this.isUsingFatJarPlugin() || super.isFatJar();
    }

    private boolean isUsingFatJarPlugin() {
        MavenProject project = this.getProject();
        Plugin shade = project.getPlugin("org.apache.maven.plugins:maven-shade-plugin");
        Plugin vertx = project.getPlugin("io.fabric8:vertx-maven-plugin");
        return shade != null || vertx != null;
    }

    protected List<String> extractPorts() {
        Map extractedPorts = new VertxPortsExtractor(this.log).extract(this.getProject());
        ArrayList<String> ports = new ArrayList<String>();
        for (Integer p : extractedPorts.values()) {
            ports.add(String.valueOf(p));
        }
        return ports.size() > 0 ? ports : super.extractPorts();
    }
}

