/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.springboot;

import com.google.common.base.Strings;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.SpringBootConfigurationHelper;
import io.fabric8.maven.core.util.SpringBootUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.api.GeneratorMode;
import io.fabric8.maven.generator.javaexec.FatJarDetector;
import io.fabric8.maven.generator.javaexec.JavaExecGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class SpringBootGenerator
extends JavaExecGenerator {
    private static final String DEFAULT_SERVER_PORT = "8080";

    public SpringBootGenerator(GeneratorContext context) {
        super(context, "spring-boot");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && MavenUtil.hasPluginOfAnyGroupId((MavenProject)this.getProject(), (String)"spring-boot-maven-plugin");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean isPrePackagePhase) throws MojoExecutionException {
        if (this.getContext().getGeneratorMode() == GeneratorMode.WATCH) {
            this.ensureSpringDevToolSecretToken();
            if (!isPrePackagePhase) {
                this.addDevToolsFilesToFatJar(configs);
            }
        }
        return super.customize(configs, isPrePackagePhase);
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) throws MojoExecutionException {
        String secret;
        Map res = super.getEnv(prePackagePhase);
        if (this.getContext().getGeneratorMode() == GeneratorMode.WATCH && (secret = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)MavenUtil.getCompileClassLoader((MavenProject)this.getProject())).getProperty("spring.devtools.remote.secret")) != null) {
            res.put("SPRING_DEVTOOLS_REMOTE_SECRET", secret);
        }
        return res;
    }

    protected List<String> getExtraJavaOptions() {
        List opts = super.getExtraJavaOptions();
        if (Boolean.parseBoolean(this.getConfig(Config.color))) {
            opts.add("-Dspring.output.ansi.enabled=" + this.getConfig(Config.color));
        }
        return opts;
    }

    protected boolean isFatJar() throws MojoExecutionException {
        if (!this.hasMainClass() && this.isSpringBootRepackage()) {
            return true;
        }
        return super.isFatJar();
    }

    protected List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)MavenUtil.getCompileClassLoader((MavenProject)this.getProject()));
        SpringBootConfigurationHelper propertyHelper = new SpringBootConfigurationHelper(SpringBootUtil.getSpringBootVersion((MavenProject)this.getProject()));
        String port = properties.getProperty(propertyHelper.getServerPortPropertyKey(), DEFAULT_SERVER_PORT);
        this.addPortIfValid(answer, this.getConfig((Configs.Key)JavaExecGenerator.Config.webPort, port));
        this.addPortIfValid(answer, this.getConfig((Configs.Key)JavaExecGenerator.Config.jolokiaPort));
        this.addPortIfValid(answer, this.getConfig((Configs.Key)JavaExecGenerator.Config.prometheusPort));
        return answer;
    }

    private void ensureSpringDevToolSecretToken() throws MojoExecutionException {
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((URLClassLoader)MavenUtil.getCompileClassLoader((MavenProject)this.getProject()));
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret");
        if (Strings.isNullOrEmpty((String)remoteSecret)) {
            this.addSecretTokenToApplicationProperties();
            throw new MojoExecutionException("No spring.devtools.remote.secret found in application.properties. Plugin has added it, please re-run goals");
        }
    }

    private void addDevToolsFilesToFatJar(List<ImageConfiguration> configs) throws MojoExecutionException {
        if (this.isFatJar()) {
            File target = this.getFatJarFile();
            try {
                File devToolsFile = this.getSpringBootDevToolsJar();
                File applicationPropertiesFile = new File(this.getProject().getBasedir(), "target/classes/application.properties");
                this.copyFilesToFatJar(Collections.singletonList(devToolsFile), Collections.singletonList(applicationPropertiesFile), target);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to add devtools files to fat jar " + target + ". " + e, e);
            }
        }
    }

    private File getFatJarFile() throws MojoExecutionException {
        FatJarDetector.Result fatJarDetectResult = this.detectFatJar();
        if (fatJarDetectResult == null) {
            throw new MojoExecutionException("No fat jar built yet. Please ensure that the 'package' phase has run");
        }
        return fatJarDetectResult.getArchiveFile();
    }

    private void copyFilesToFatJar(List<File> libs, List<File> classes, File target) throws IOException {
        Throwable throwable;
        FileInputStream in;
        File tmpZip = File.createTempFile(target.getName(), null);
        tmpZip.delete();
        FileUtils.moveFile((File)target, (File)tmpZip);
        byte[] buffer = new byte[8192];
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tmpZip));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(target));
        ZipEntry ze = zin.getNextEntry();
        while (ze != null) {
            if (!this.matchesFatJarEntry(libs, ze.getName(), true) && !this.matchesFatJarEntry(classes, ze.getName(), false)) {
                out.putNextEntry(ze);
                int read = zin.read(buffer);
                while (read > -1) {
                    out.write(buffer, 0, read);
                    read = zin.read(buffer);
                }
                out.closeEntry();
            }
            ze = zin.getNextEntry();
        }
        for (File lib : libs) {
            in = new FileInputStream(lib);
            throwable = null;
            try {
                out.putNextEntry(this.createZipEntry(lib, this.getFatJarFullPath(lib, true)));
                int read = ((InputStream)in).read(buffer);
                while (read > -1) {
                    out.write(buffer, 0, read);
                    read = ((InputStream)in).read(buffer);
                }
                out.closeEntry();
            }
            catch (Throwable read) {
                throwable = read;
                throw read;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable read) {
                        throwable.addSuppressed(read);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        for (File cls : classes) {
            in = new FileInputStream(cls);
            throwable = null;
            try {
                out.putNextEntry(this.createZipEntry(cls, this.getFatJarFullPath(cls, false)));
                int read = ((InputStream)in).read(buffer);
                while (read > -1) {
                    out.write(buffer, 0, read);
                    read = ((InputStream)in).read(buffer);
                }
                out.closeEntry();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        out.close();
        tmpZip.delete();
    }

    private boolean matchesFatJarEntry(List<File> fatJarEntries, String path, boolean lib) {
        for (File e : fatJarEntries) {
            String fullPath = this.getFatJarFullPath(e, lib);
            if (!fullPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private String getFatJarFullPath(File file, boolean lib) {
        if (lib) {
            return "BOOT-INF/lib/" + file.getName();
        }
        return "BOOT-INF/classes/" + file.getName();
    }

    private ZipEntry createZipEntry(File file, String fullPath) throws IOException {
        ZipEntry entry = new ZipEntry(fullPath);
        byte[] buffer = new byte[8192];
        int bytesRead = -1;
        try (FileInputStream is = new FileInputStream(file);){
            CRC32 crc = new CRC32();
            int size = 0;
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
                size += bytesRead;
            }
            entry.setSize(size);
            entry.setCompressedSize(size);
            entry.setCrc(crc.getValue());
            entry.setMethod(0);
            ZipEntry zipEntry = entry;
            return zipEntry;
        }
    }

    private void addSecretTokenToApplicationProperties() throws MojoExecutionException {
        String newToken = UUID.randomUUID().toString();
        this.log.verbose("Generating the spring devtools token in property: spring.devtools.remote.secret", new Object[0]);
        this.appendSecretTokenToFile("target/classes/application.properties", newToken);
        this.appendSecretTokenToFile("src/main/resources/application.properties", newToken);
    }

    private void appendSecretTokenToFile(String path, String token) throws MojoExecutionException {
        File file = new File(this.getProject().getBasedir(), path);
        file.getParentFile().mkdirs();
        String text = String.format("%s# Remote secret added by fabric8-maven-plugin\n%s=%s\n", file.exists() ? "\n" : "", "spring.devtools.remote.secret", token);
        try (FileWriter writer = new FileWriter(file, true);){
            writer.append(text);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to append to file: " + file + ". " + e, (Exception)e);
        }
    }

    private boolean isSpringBootRepackage() {
        Map executionsAsMap;
        MavenProject project = this.getProject();
        Plugin plugin = MavenUtil.getPluginOfAnyGroupId((MavenProject)project, (String)"spring-boot-maven-plugin");
        if (plugin != null && (executionsAsMap = plugin.getExecutionsAsMap()) != null) {
            for (PluginExecution execution : executionsAsMap.values()) {
                List goals = execution.getGoals();
                if (!goals.contains("repackage")) continue;
                this.log.verbose("Using fat jar packaging as the spring boot plugin is using `repackage` goal execution", new Object[0]);
                return true;
            }
        }
        return false;
    }

    private File getSpringBootDevToolsJar() throws IOException {
        String version = (String)SpringBootUtil.getSpringBootDevToolsVersion((MavenProject)this.getProject()).orElseThrow(() -> new IllegalStateException("Unable to find the spring-boot version"));
        return this.getContext().getArtifactResolver().resolveArtifact("org.springframework.boot", "spring-boot-devtools", version, "jar");
    }

    public static enum Config implements Configs.Key
    {
        color{
            {
                this.d = "false";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

