/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.springboot;

import com.google.common.base.Strings;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.SpringBootUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.javaexec.FatJarDetector;
import io.fabric8.maven.generator.javaexec.JavaExecGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class SpringBootGenerator
extends JavaExecGenerator {
    private static final String SPRING_BOOT_MAVEN_PLUGIN_GA = "org.springframework.boot:spring-boot-maven-plugin";
    private static final String SPRING_BOOT_DEVTOOLS_ENTRY = "fabric8-spring-devtools/spring-boot-devtools.jar";

    public SpringBootGenerator(GeneratorContext context) {
        super(context, "spring-boot");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)SPRING_BOOT_MAVEN_PLUGIN_GA);
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean isPrePackagePhase) throws MojoExecutionException {
        if (!isPrePackagePhase && this.getContext().isWatchMode()) {
            this.ensureSpringDevToolSecretToken();
            this.addDevToolsToFatJar(configs);
        }
        return super.customize(configs, isPrePackagePhase);
    }

    protected Map<String, String> getEnv(boolean isPrePackagePhase) throws MojoExecutionException {
        Map ret = super.getEnv(isPrePackagePhase);
        if (Boolean.parseBoolean(this.getConfig(Config.color))) {
            ret.put("JAVA_OPTIONS", "-Dspring.output.ansi.enabled=" + this.getConfig(Config.color));
        }
        return ret;
    }

    protected boolean isFatJar() throws MojoExecutionException {
        if (!this.hasMainClass() && this.isSpringBootRepackage()) {
            return true;
        }
        return super.isFatJar();
    }

    private void ensureSpringDevToolSecretToken() throws MojoExecutionException {
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((MavenProject)this.getProject());
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret");
        if (Strings.isNullOrEmpty((String)remoteSecret)) {
            this.addSecretTokenToApplicationProperties();
        }
    }

    private void addDevToolsToFatJar(List<ImageConfiguration> configs) throws MojoExecutionException {
        if (this.isFatJar()) {
            File target = this.getFatJarFile();
            String devToolsFile = this.getDevToolsJarContainingJarFile();
            try (FileSystem devToolsJarFs = FileSystems.newFileSystem(new URI("jar:" + devToolsFile), Collections.emptyMap());){
                Path resourcePath = devToolsJarFs.getPath(SPRING_BOOT_DEVTOOLS_ENTRY, new String[0]);
                URI targetUri = new URI("jar:file:" + target.getAbsolutePath());
                this.copyDevToolsJarToFatTargetJar(resourcePath, targetUri);
            }
            catch (IOException | URISyntaxException e) {
                throw new MojoExecutionException("Failed to add fabric8-spring-devtools/spring-boot-devtools.jar to temp file " + target + ". " + e, e);
            }
        }
    }

    private File getFatJarFile() throws MojoExecutionException {
        FatJarDetector.Result fatJarDetectResult = this.detectFatJar();
        if (fatJarDetectResult == null) {
            throw new MojoExecutionException("No fat jar built yet. Please ensure that the 'package' phase has run");
        }
        return fatJarDetectResult.getArchiveFile();
    }

    private String getDevToolsJarContainingJarFile() throws MojoExecutionException {
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(SPRING_BOOT_DEVTOOLS_ENTRY);
        if (resource == null) {
            throw new MojoExecutionException("Could not find resource fabric8-spring-devtools/spring-boot-devtools.jar on the classpath!");
        }
        try {
            String all = resource.toURI().getRawSchemeSpecificPart();
            int idx = all.indexOf("!/");
            if (idx == -1) {
                throw new MojoExecutionException("Internal error: Cannot extract tools jar from internal jar");
            }
            return all.substring(0, idx);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Invalid URI syntax of " + resource, (Exception)e);
        }
    }

    private void copyDevToolsJarToFatTargetJar(Path resourcePath, URI uri) throws IOException {
        try (FileSystem jarfs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
            Files.copy(resourcePath, jarfs.getPath("/BOOT-INF/lib/spring-devtools.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void addSecretTokenToApplicationProperties() throws MojoExecutionException {
        String newToken = UUID.randomUUID().toString();
        this.log.verbose("Generating the spring devtools token in property: spring.devtools.remote.secret", new Object[0]);
        File file = new File(this.getProject().getBasedir(), "target/classes/application.properties");
        file.getParentFile().mkdirs();
        String text = String.format("%s# Remote secret added by fabric8-maven-plugin\n%s=%s\n", file.exists() ? "\n" : "", "spring.devtools.remote.secret", newToken);
        try (FileWriter writer = new FileWriter(file, true);){
            writer.append(text);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to append to file: " + file + ". " + e, (Exception)e);
        }
    }

    private boolean isSpringBootRepackage() {
        Map executionsAsMap;
        MavenProject project = this.getProject();
        Plugin plugin = project.getPlugin(SPRING_BOOT_MAVEN_PLUGIN_GA);
        if (plugin != null && (executionsAsMap = plugin.getExecutionsAsMap()) != null) {
            for (PluginExecution execution : executionsAsMap.values()) {
                List goals = execution.getGoals();
                if (!goals.contains("repackage")) continue;
                this.log.verbose("Using fat jar packaging as the spring boot plugin is using `repackage` goal execution", new Object[0]);
                return true;
            }
        }
        return false;
    }

    public static enum Config implements Configs.Key
    {
        color{
            {
                this.d = "false";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

