/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.springboot;

import com.google.common.base.Strings;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import io.fabric8.maven.generator.api.support.JavaRunGenerator;
import io.fabric8.utils.IOHelpers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class SpringBootGenerator
extends JavaRunGenerator {
    public static final String SPRING_BOOT_MAVEN_PLUGIN_GA = "org.springframework.boot:spring-boot-maven-plugin";
    private Boolean springBootRepackage;

    public SpringBootGenerator(MavenGeneratorContext context) {
        super(context, "spring-boot");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddDefaultImage(configs) && MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)SPRING_BOOT_MAVEN_PLUGIN_GA) && this.isSpringBootRepackage();
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) throws MojoExecutionException {
        if (this.getContext().isWatchMode()) {
            this.generateSpringDevToolsToken();
            this.addDevToolsJar(configs);
        }
        return super.customize(configs);
    }

    private void generateSpringDevToolsToken() throws MojoExecutionException {
        Properties properties = MavenUtil.getSpringBootApplicationProperties((MavenProject)this.getProject());
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret");
        if (Strings.isNullOrEmpty((String)remoteSecret)) {
            String newToken = UUID.randomUUID().toString();
            this.log.verbose("Generating the spring devtools token in property: spring.devtools.remote.secret", new Object[0]);
            File file = new File(this.getProject().getBasedir(), "target/classes/application.properties");
            file.getParentFile().mkdirs();
            String text = "# lets configure the spring devtools remote secret\nspring.devtools.remote.secret=" + newToken + "\n";
            if (file.exists()) {
                text = "\n" + text;
            }
            try (FileWriter writer = new FileWriter(file, true);){
                writer.append(text);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to append to file: " + file + ". " + e, (Exception)e);
            }
        }
    }

    private void addDevToolsJar(List<ImageConfiguration> configs) throws MojoExecutionException {
        if (Objects.equals("fabric8:resource", this.getContext().getGoalName()) && this.isFatJarWithNoDependencies()) {
            MavenProject project = this.getProject();
            File basedir = project.getBasedir();
            File outputFile = new File(basedir, "target/classes/BOOT-INF/lib/spring-devtools.jar");
            outputFile.getParentFile().mkdirs();
            String resourceName = "fabric8-spring-devtools/spring-boot-devtools.jar";
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
            if (resource == null) {
                throw new MojoExecutionException("Could not find resource " + resourceName + " on the classpath!");
            }
            try {
                IOHelpers.copy((InputStream)resource.openStream(), (OutputStream)new FileOutputStream(outputFile));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy " + resource + " to temp file " + outputFile + ". " + e, (Exception)e);
            }
        }
    }

    protected Map<String, String> getEnv() {
        Map ret = super.getEnv();
        if (this.getConfig(Config.color) != null) {
            ret.put("JAVA_OPTIONS", "-Dspring.output.ansi.enabled=" + this.getConfig(Config.color));
        }
        return ret;
    }

    protected boolean isFatJarWithNoDependencies() {
        boolean springBootRepackage;
        String fatJarConfig = this.getConfig((Configs.Key)JavaRunGenerator.Config.fatJar);
        if (Strings.isNullOrEmpty((String)fatJarConfig) && (springBootRepackage = this.isSpringBootRepackage())) {
            return true;
        }
        return super.isFatJarWithNoDependencies();
    }

    protected boolean isSpringBootRepackage() {
        if (this.springBootRepackage == null) {
            Map executionsAsMap;
            Plugin plugin;
            this.springBootRepackage = false;
            MavenProject project = this.getProject();
            if (project != null && (plugin = project.getPlugin(SPRING_BOOT_MAVEN_PLUGIN_GA)) != null && (executionsAsMap = plugin.getExecutionsAsMap()) != null) {
                for (PluginExecution execution : executionsAsMap.values()) {
                    List goals = execution.getGoals();
                    if (!goals.contains("repackage")) continue;
                    this.springBootRepackage = true;
                    this.log.info("Using fat jar packaging as the spring boot plugin is using `repackage` goal execution", new Object[0]);
                    break;
                }
            }
        }
        return this.springBootRepackage;
    }

    public static enum Config implements Configs.Key
    {
        color;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

