/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.springboot;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.BaseGenerator;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class SpringBootGenerator
extends BaseGenerator {
    private static final String S2I_BUILDER_IMAGE = "fabric8/s2i-java";
    private static final String BASE_IMAGE = "fabric8/java-alpine-openjdk8-jdk";

    public SpringBootGenerator(MavenGeneratorContext context) {
        super(context, "spring-boot");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) {
        if (this.isApplicable() && this.shouldIncludeDefaultImage(configs)) {
            ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
            BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().assembly(this.createAssembly()).from(this.getFrom()).ports(this.extractPorts());
            this.addLatestTagIfSnapshot(buildBuilder);
            imageBuilder.name(this.getConfig(Config.name)).alias(this.getConfig(Config.alias)).buildConfig(buildBuilder.build());
            configs.add(imageBuilder.build());
            return configs;
        }
        return configs;
    }

    private String getFrom() {
        String from = this.getConfig(Config.from);
        if (from != null) {
            return from;
        }
        MavenGeneratorContext ctx = this.getContext();
        PlatformMode mode = ctx.getMode();
        OpenShiftBuildStrategy strategy = ctx.getStrategy();
        return mode == PlatformMode.openshift && strategy == OpenShiftBuildStrategy.s2i ? S2I_BUILDER_IMAGE : BASE_IMAGE;
    }

    public boolean isApplicable() {
        MavenProject project = this.getProject();
        return MavenUtil.hasPlugin((MavenProject)project, (String)"org.springframework.boot:spring-boot-maven-plugin");
    }

    private boolean shouldIncludeDefaultImage(List<ImageConfiguration> configs) {
        boolean combineEnabled = Configs.asBoolean((String)this.getConfig(Config.combine));
        return !this.containsBuildConfiguration(configs) || combineEnabled;
    }

    private List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        this.addPortIfValid(answer, this.getConfig(Config.webPort));
        this.addPortIfValid(answer, this.getConfig(Config.jolokiaPort));
        this.addPortIfValid(answer, this.getConfig(Config.prometheusPort));
        return answer;
    }

    private void addPortIfValid(List<String> list, String port) {
        if (Strings.isNotBlank((String)port)) {
            list.add(port);
        }
    }

    private AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().basedir("/app").descriptorRef("artifact").build();
    }

    private static enum Config implements Configs.Key
    {
        combine{
            {
                this.d = "false";
            }
        }
        ,
        name{
            {
                this.d = "%g/%a:%l";
            }
        }
        ,
        alias{
            {
                this.d = "springboot";
            }
        }
        ,
        from,
        webPort{
            {
                this.d = "8080";
            }
        }
        ,
        jolokiaPort{
            {
                this.d = "8778";
            }
        }
        ,
        prometheusPort{
            {
                this.d = "9779";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

