/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.springboot;

import com.google.common.base.Strings;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import io.fabric8.maven.generator.api.support.JavaRunGenerator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;

public class SpringBootGenerator
extends JavaRunGenerator {
    public static final String SPRING_BOOT_MAVEN_PLUGIN_GA = "org.springframework.boot:spring-boot-maven-plugin";

    public SpringBootGenerator(MavenGeneratorContext context) {
        super(context, "spring-boot");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddDefaultImage(configs) && MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)SPRING_BOOT_MAVEN_PLUGIN_GA) && this.isSpringBootRepackage();
    }

    protected boolean isFatJarWithNoDependencies() {
        boolean springBootRepackage;
        String fatJarConfig = this.getConfig((Configs.Key)JavaRunGenerator.Config.fatJar);
        if (Strings.isNullOrEmpty((String)fatJarConfig) && (springBootRepackage = this.isSpringBootRepackage())) {
            this.log.info("Using fat jar packaging as the spring boot plugin is using `repackage` goal execution", new Object[0]);
            return true;
        }
        return super.isFatJarWithNoDependencies();
    }

    protected boolean isSpringBootRepackage() {
        Map executionsAsMap;
        Plugin plugin;
        boolean springBootRepackage = false;
        MavenProject project = this.getProject();
        if (project != null && (plugin = project.getPlugin(SPRING_BOOT_MAVEN_PLUGIN_GA)) != null && (executionsAsMap = plugin.getExecutionsAsMap()) != null) {
            for (PluginExecution execution : executionsAsMap.values()) {
                List goals = execution.getGoals();
                if (!goals.contains("repackage")) continue;
                springBootRepackage = true;
                break;
            }
        }
        return springBootRepackage;
    }
}

