/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.karaf;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.FromSelector;
import io.fabric8.maven.generator.api.GeneratorContext;
import io.fabric8.maven.generator.api.support.BaseGenerator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.project.MavenProject;

public class KarafGenerator
extends BaseGenerator {
    private static final String KARAF_MAVEN_PLUGIN_ARTIFACT_ID = "karaf-maven-plugin";

    public KarafGenerator(GeneratorContext context) {
        super(context, "karaf", (FromSelector)new FromSelector.Default(context, "karaf"));
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
        BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().ports(this.extractPorts()).cmd(new Arguments(this.getConfig(Config.cmd)));
        this.addFrom(buildBuilder);
        if (!prePackagePhase) {
            buildBuilder.assembly(this.createAssembly());
        }
        this.addLatestTagIfSnapshot(buildBuilder);
        imageBuilder.name(this.getImageName()).alias(this.getAlias()).buildConfig(buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && MavenUtil.hasPluginOfAnyGroupId((MavenProject)this.getProject(), (String)KARAF_MAVEN_PLUGIN_ARTIFACT_ID);
    }

    protected List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        this.addPortIfValid(answer, this.getConfig(Config.webPort));
        this.addPortIfValid(answer, this.getConfig(Config.jolokiaPort));
        return answer;
    }

    private void addPortIfValid(List<String> list, String port) {
        if (StringUtils.isNotBlank((CharSequence)port)) {
            list.add(port);
        }
    }

    private AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().targetDir(this.getConfig(Config.baseDir)).user(this.getConfig(Config.user)).descriptorRef("karaf").build();
    }

    private static enum Config implements Configs.Key
    {
        baseDir{
            {
                this.d = "/deployments/";
            }
        }
        ,
        user{
            {
                this.d = "jboss:jboss:jboss";
            }
        }
        ,
        cmd{
            {
                this.d = "/deployments/deploy-and-run.sh";
            }
        }
        ,
        webPort{
            {
                this.d = "8181";
            }
        }
        ,
        jolokiaPort{
            {
                this.d = "8778";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

