/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.javaexec;

import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import io.fabric8.maven.generator.api.support.JavaRunGenerator;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JavaExecGenerator
extends JavaRunGenerator {
    public static final String JAVA_MAIN_CLASS = "JAVA_MAIN_CLASS";
    private String mainClass = null;
    private boolean alreadySearchedForMainClass = false;

    public JavaExecGenerator(MavenGeneratorContext context) {
        super(context, "java-exec");
    }

    protected Map<String, String> getEnv() {
        Map ret = super.getEnv();
        ret.put(JAVA_MAIN_CLASS, this.getMainClass());
        return ret;
    }

    private String getMainClass() {
        if (this.alreadySearchedForMainClass) {
            return this.mainClass;
        }
        String mc = this.getConfig(Config.mainClass);
        if (mc != null) {
            return mc;
        }
        try {
            List foundMainClasses = ClassUtil.findMainClasses((File)new File(this.getContext().getProject().getBuild().getOutputDirectory()));
            if (foundMainClasses.size() == 0) {
                this.mainClass = null;
                String string = null;
                return string;
            }
            if (foundMainClasses.size() == 1) {
                String string = this.mainClass = (String)foundMainClasses.get(0);
                return string;
            }
            this.log.warn("Found more than one main class : " + foundMainClasses + ". Ignoring ....", new Object[0]);
            this.mainClass = null;
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not examine main classes: " + e, e);
        }
        finally {
            this.alreadySearchedForMainClass = true;
        }
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddDefaultImage(configs) && Strings.isNotBlank((String)this.getMainClass());
    }

    private static enum Config implements Configs.Key
    {
        mainClass;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

