/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.javaexec;

import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.BaseGenerator;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JavaExecGenerator
extends BaseGenerator {
    public static final String JAVA_MAIN_CLASS = "JAVA_MAIN_CLASS";
    private String mainClass = null;
    private boolean alreadySearchedForMainClass = false;

    public JavaExecGenerator(MavenGeneratorContext context) {
        super(context, "java-exec");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) {
        if (this.isApplicable() && this.shouldIncludeDefaultImage(configs)) {
            HashMap<String, String> envVars = new HashMap<String, String>();
            envVars.put(JAVA_MAIN_CLASS, this.getMainClass());
            ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
            BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().assembly(this.createAssembly()).from(this.getConfig(Config.from)).ports(this.extractPorts()).env(envVars);
            this.addLatestTagIfSnapshot(buildBuilder);
            imageBuilder.name(this.getConfig(Config.name)).alias(this.getConfig(Config.alias)).buildConfig(buildBuilder.build());
            configs.add(imageBuilder.build());
            return configs;
        }
        return configs;
    }

    private String getMainClass() {
        if (this.alreadySearchedForMainClass) {
            return this.mainClass;
        }
        String mc = this.getConfig(Config.mainClass);
        if (mc != null) {
            return mc;
        }
        try {
            List foundMainClasses = ClassUtil.findMainClasses((File)new File(this.getContext().getProject().getBuild().getOutputDirectory()));
            if (foundMainClasses.size() == 0) {
                this.mainClass = null;
                String string = null;
                return string;
            }
            if (foundMainClasses.size() == 1) {
                String string = this.mainClass = (String)foundMainClasses.get(0);
                return string;
            }
            this.log.warn("Found more than one main class : " + foundMainClasses + ". Ignoring ....", new Object[0]);
            this.mainClass = null;
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot examine main classes: " + e, e);
        }
        finally {
            this.alreadySearchedForMainClass = true;
        }
    }

    public boolean isApplicable() {
        return Strings.isNotBlank((String)this.getMainClass());
    }

    private boolean shouldIncludeDefaultImage(List<ImageConfiguration> configs) {
        boolean combineEnabled = Configs.asBoolean((String)this.getConfig(Config.combine));
        return !this.containsBuildConfiguration(configs) || combineEnabled;
    }

    private List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        this.addPortIfValid(answer, this.getConfig(Config.port));
        this.addPortIfValid(answer, this.getConfig(Config.jolokiaPort));
        this.addPortIfValid(answer, this.getConfig(Config.prometheusPort));
        return answer;
    }

    private void addPortIfValid(List<String> list, String port) {
        if (Strings.isNotBlank((String)port)) {
            list.add(port);
        }
    }

    private AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().basedir("/app").descriptorRef("java-app").build();
    }

    private static enum Config implements Configs.Key
    {
        mainClass,
        combine{
            {
                this.d = "false";
            }
        }
        ,
        name{
            {
                this.d = "%g/%a:%l";
            }
        }
        ,
        alias{
            {
                this.d = "java-exec";
            }
        }
        ,
        from{
            {
                this.d = "fabric8/java-alpine-openjdk8-jdk";
            }
        }
        ,
        port,
        jolokiaPort{
            {
                this.d = "8778";
            }
        }
        ,
        prometheusPort{
            {
                this.d = "9779";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

