/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.service.ArtifactResolverService;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.generator.api.GeneratorMode;
import org.apache.maven.project.MavenProject;

public class GeneratorContext {
    private MavenProject project;
    private ProcessorConfig config;
    private Logger logger;
    private PlatformMode platformMode;
    private OpenShiftBuildStrategy strategy;
    private boolean useProjectClasspath;
    private boolean prePackagePhase;
    private ArtifactResolverService artifactResolver;
    private GeneratorMode generatorMode = GeneratorMode.BUILD;

    private GeneratorContext() {
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PlatformMode getPlatformMode() {
        return this.platformMode;
    }

    public OpenShiftBuildStrategy getStrategy() {
        return this.strategy;
    }

    public GeneratorMode getGeneratorMode() {
        return this.generatorMode;
    }

    public ArtifactResolverService getArtifactResolver() {
        return this.artifactResolver;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public boolean isPrePackagePhase() {
        return this.prePackagePhase;
    }

    public static class Builder {
        private GeneratorContext ctx = new GeneratorContext();

        public Builder config(ProcessorConfig config) {
            this.ctx.config = config;
            return this;
        }

        public Builder project(MavenProject project) {
            this.ctx.project = project;
            return this;
        }

        public Builder generatorMode(GeneratorMode generatorMode) {
            this.ctx.generatorMode = generatorMode;
            return this;
        }

        public Builder logger(Logger logger) {
            this.ctx.logger = logger;
            return this;
        }

        public Builder platformMode(PlatformMode mode) {
            this.ctx.platformMode = mode;
            return this;
        }

        public Builder strategy(OpenShiftBuildStrategy strategy) {
            this.ctx.strategy = strategy;
            return this;
        }

        public Builder useProjectClasspath(boolean useProjectClasspath) {
            this.ctx.useProjectClasspath = useProjectClasspath;
            return this;
        }

        public Builder prePackagePhase(boolean prePackagePhase) {
            this.ctx.prePackagePhase = prePackagePhase;
            return this;
        }

        public Builder artifactResolver(ArtifactResolverService artifactResolver) {
            this.ctx.artifactResolver = artifactResolver;
            return this;
        }

        public GeneratorContext build() {
            return this.ctx;
        }
    }
}

