/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.generator.api.DefaultImageLookup;
import io.fabric8.maven.generator.api.GeneratorContext;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;

public abstract class FromSelector {
    private final GeneratorContext context;
    private final Pattern REDHAT_VERSION_PATTERN = Pattern.compile("^.*\\.(redhat|fuse)-.*$");

    public FromSelector(GeneratorContext context) {
        this.context = context;
    }

    public String getFrom() {
        PlatformMode mode = this.context.getPlatformMode();
        OpenShiftBuildStrategy strategy = this.context.getStrategy();
        if (mode == PlatformMode.openshift && strategy == OpenShiftBuildStrategy.s2i) {
            return this.getS2iBuildFrom();
        }
        return this.getDockerBuildFrom();
    }

    public Map<String, String> getImageStreamTagFromExt() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(OpenShiftBuildStrategy.SourceStrategy.kind.key(), "ImageStreamTag");
        ret.put(OpenShiftBuildStrategy.SourceStrategy.namespace.key(), "openshift");
        ret.put(OpenShiftBuildStrategy.SourceStrategy.name.key(), this.getIstagFrom());
        return ret;
    }

    protected abstract String getDockerBuildFrom();

    protected abstract String getS2iBuildFrom();

    protected abstract String getIstagFrom();

    public boolean isRedHat() {
        MavenProject project = this.context.getProject();
        Plugin plugin = project.getPlugin("io.fabric8:fabric8-maven-plugin");
        if (plugin == null) {
            plugin = project.getPlugin("org.jboss.redhat-fuse:fabric8-maven-plugin");
        }
        if (plugin == null) {
            return false;
        }
        String version = plugin.getVersion();
        return this.REDHAT_VERSION_PATTERN.matcher(version).matches();
    }

    public static class Default
    extends FromSelector {
        private final String upstreamDocker;
        private final String upstreamS2i;
        private final String redhatDocker;
        private final String redhatS2i;
        private final String redhatIstag;
        private final String upstreamIstag;

        public Default(GeneratorContext context, String prefix) {
            super(context);
            DefaultImageLookup lookup = new DefaultImageLookup(Default.class);
            this.upstreamDocker = lookup.getImageName(prefix + ".upstream.docker");
            this.upstreamS2i = lookup.getImageName(prefix + ".upstream.s2i");
            this.upstreamIstag = lookup.getImageName(prefix + ".upstream.istag");
            this.redhatDocker = lookup.getImageName(prefix + ".redhat.docker");
            this.redhatS2i = lookup.getImageName(prefix + ".redhat.s2i");
            this.redhatIstag = lookup.getImageName(prefix + ".redhat.istag");
        }

        @Override
        protected String getDockerBuildFrom() {
            return this.isRedHat() ? this.redhatDocker : this.upstreamDocker;
        }

        @Override
        protected String getS2iBuildFrom() {
            return this.isRedHat() ? this.redhatS2i : this.upstreamS2i;
        }

        @Override
        protected String getIstagFrom() {
            return this.isRedHat() ? this.redhatIstag : this.upstreamIstag;
        }
    }
}

