/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.Configs;
import java.util.Properties;

public class GeneratorConfig {
    private static final String GENERATOR_PROP_PREFIX = "fabric8.generator";
    private final String name;
    private final ProcessorConfig config;
    private final Properties properties;

    public GeneratorConfig(Properties properties, String name, ProcessorConfig config) {
        this.config = config != null ? config : ProcessorConfig.INCLUDE_ALL;
        this.name = name;
        this.properties = properties;
    }

    public String get(Configs.Key key) {
        return this.get(key, key.def());
    }

    public String get(Configs.Key key, String defaultVal) {
        String keyVal = key != null ? key.name() : "";
        String val = this.config.getConfig(this.name, key.name());
        if (val == null) {
            String fullKey = "fabric8.generator." + this.name + "." + key;
            val = Configs.getPropertyWithSystemAsFallback((Properties)this.properties, (String)fullKey);
        }
        return val != null ? val : defaultVal;
    }
}

