/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api.support;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.generator.api.FromSelector;
import io.fabric8.maven.generator.api.Generator;
import io.fabric8.maven.generator.api.GeneratorConfig;
import io.fabric8.maven.generator.api.GeneratorContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;

public abstract class BaseGenerator
implements Generator {
    private final GeneratorContext context;
    private final String name;
    private final GeneratorConfig config;
    protected final PrefixedLogger log;
    private final FromSelector fromSelector;

    public BaseGenerator(GeneratorContext context, String name) {
        this(context, name, null);
    }

    public BaseGenerator(GeneratorContext context, String name, FromSelector fromSelector) {
        this.context = context;
        this.name = name;
        this.fromSelector = fromSelector;
        this.config = new GeneratorConfig(context.getProject().getProperties(), this.getName(), context.getConfig());
        this.log = new PrefixedLogger(name, context.getLogger());
    }

    protected MavenProject getProject() {
        return this.context.getProject();
    }

    public String getName() {
        return this.name;
    }

    public GeneratorContext getContext() {
        return this.context;
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected String getFromAsConfigured() {
        return this.getConfigWithSystemFallbackAndDefault(Config.from, "fabric8.generator.from", null);
    }

    protected void addFrom(BuildImageConfiguration.Builder builder) {
        String fromMode = this.getConfigWithSystemFallbackAndDefault(Config.fromMode, "fabric8.generator.fromMode", this.getFromModeDefault(this.context.getMode()));
        String from = this.getConfigWithSystemFallbackAndDefault(Config.from, "fabric8.generator.from", null);
        if (fromMode.equalsIgnoreCase("docker")) {
            String fromImage = from;
            if (fromImage == null) {
                fromImage = this.fromSelector != null ? this.fromSelector.getFrom() : null;
            }
            builder.from(fromImage);
            this.log.info("Using Docker image %s as base / builder", new Object[]{fromImage});
        } else if (fromMode.equalsIgnoreCase("istag")) {
            HashMap<String, String> fromExt = new HashMap<String, String>();
            if (from != null) {
                ImageName iName = new ImageName(from);
                String tag = iName.getTag();
                if (StringUtils.isBlank((String)tag)) {
                    tag = "latest";
                }
                fromExt.put(OpenShiftBuildStrategy.SourceStrategy.name.key(), iName.getSimpleName() + ":" + tag);
                if (iName.getUser() != null) {
                    fromExt.put(OpenShiftBuildStrategy.SourceStrategy.namespace.key(), iName.getUser());
                }
                fromExt.put(OpenShiftBuildStrategy.SourceStrategy.kind.key(), "ImageStreamTag");
            } else {
                Map<String, String> map = fromExt = this.fromSelector != null ? this.fromSelector.getImageStreamTagFromExt() : null;
            }
            if (fromExt != null) {
                String namespace = (String)fromExt.get(OpenShiftBuildStrategy.SourceStrategy.namespace.key());
                if (namespace != null) {
                    this.log.info("Using ImageStreamTag '%s' from namespace '%s' as builder image", new Object[]{fromExt.get(OpenShiftBuildStrategy.SourceStrategy.name.key()), namespace});
                } else {
                    this.log.info("Using ImageStreamTag '%s' as builder image", new Object[]{fromExt.get(OpenShiftBuildStrategy.SourceStrategy.name.key())});
                }
                builder.fromExt(fromExt);
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid 'fromMode' in generator configuration for '%s'", this.getName()));
        }
    }

    private String getFromModeDefault(PlatformMode mode) {
        if (mode == PlatformMode.openshift && this.fromSelector != null && this.fromSelector.isRedHat()) {
            return "istag";
        }
        return "docker";
    }

    protected String getImageName() {
        return this.getConfigWithSystemFallbackAndDefault(Config.name, "fabric8.generator.name", this.getDefaultImageUser());
    }

    private String getDefaultImageUser() {
        if (PlatformMode.isOpenShiftMode((Properties)this.getProject().getProperties())) {
            return "%a:%l";
        }
        return "%g/%a:%t";
    }

    protected String getAlias() {
        return this.getConfigWithSystemFallbackAndDefault(Config.alias, "fabric8.generator.alias", this.getName());
    }

    protected boolean shouldAddImageConfiguration(List<ImageConfiguration> configs) {
        return !this.containsBuildConfiguration(configs) || Configs.asBoolean((String)this.getConfig(Config.add));
    }

    protected String getConfigWithSystemFallbackAndDefault(Config name, String key, String defaultVal) {
        String value = this.getConfig(name);
        if (value == null) {
            value = Configs.getPropertyWithSystemAsFallback((Properties)this.getProject().getProperties(), (String)key);
        }
        return value != null ? value : defaultVal;
    }

    protected void addLatestTagIfSnapshot(BuildImageConfiguration.Builder buildBuilder) {
        MavenProject project = this.getProject();
        if (project.getVersion().endsWith("-SNAPSHOT")) {
            buildBuilder.tags(Collections.singletonList("latest"));
        }
    }

    private boolean containsBuildConfiguration(List<ImageConfiguration> configs) {
        for (ImageConfiguration config : configs) {
            if (config.getBuildConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    private static enum Config implements Configs.Key
    {
        name,
        alias,
        add{
            {
                this.d = "false";
            }
        }
        ,
        from,
        fromMode;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

