/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class MavenGeneratorContext {
    private final MavenProject project;
    private final MavenSession session;
    private final GoalFinder goalFinder;
    private final ProcessorConfig config;
    private final String goalName;
    private final Logger log;
    private final PlatformMode mode;
    private final OpenShiftBuildStrategy strategy;

    public MavenGeneratorContext(MavenProject project, MavenSession session, GoalFinder goalFinder, ProcessorConfig generatorConfig, String goalName, Logger log, PlatformMode mode, OpenShiftBuildStrategy strategy) {
        this.project = project;
        this.session = session;
        this.goalFinder = goalFinder;
        this.config = generatorConfig;
        this.goalName = goalName;
        this.log = log;
        this.mode = mode;
        this.strategy = strategy;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public GoalFinder getGoalFinder() {
        return this.goalFinder;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public String getGoalName() {
        return this.goalName;
    }

    public Logger getLog() {
        return this.log;
    }

    public PlatformMode getMode() {
        return this.mode;
    }

    public OpenShiftBuildStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isWatchMode() throws MojoExecutionException {
        return this.runningWithGoal("fabric8:watch-spring-boot", "fabric8:watch");
    }

    public boolean runningWithGoal(String ... goals) throws MojoExecutionException {
        for (String goal : goals) {
            if (!this.goalFinder.runningWithGoal(this.project, this.session, goal)) continue;
            return true;
        }
        return false;
    }
}

