/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api.support;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.generator.api.FromSelector;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import io.fabric8.maven.generator.api.support.BaseGenerator;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class JavaRunGenerator
extends BaseGenerator {
    public JavaRunGenerator(MavenGeneratorContext context, String name) {
        super(context, name, new Java(context));
    }

    @Override
    public List<ImageConfiguration> customize(List<ImageConfiguration> configs) {
        ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
        BuildImageConfiguration.Builder buildBuilder = new BuildImageConfiguration.Builder().assembly(this.createAssembly()).from(this.getFrom()).ports(this.extractPorts());
        Map<String, String> envMap = this.getEnv();
        envMap.put("JAVA_APP_DIR", this.getConfig(Config.baseDir));
        buildBuilder.env(envMap);
        this.addLatestTagIfSnapshot(buildBuilder);
        imageBuilder.name(this.getImageName()).alias(this.getAlias()).buildConfig(buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    protected Map<String, String> getEnv() {
        return new HashMap<String, String>();
    }

    protected AssemblyConfiguration createAssembly() {
        return new AssemblyConfiguration.Builder().basedir(this.getConfig(Config.baseDir)).descriptorRef(this.getAssemblyRef()).build();
    }

    protected String getAssemblyRef() {
        return this.getConfig(Config.assemblyRef);
    }

    protected List<String> extractPorts() {
        ArrayList<String> answer = new ArrayList<String>();
        this.addPortIfValid(answer, this.getConfig(Config.webPort));
        this.addPortIfValid(answer, this.getConfig(Config.jolokiaPort));
        this.addPortIfValid(answer, this.getConfig(Config.prometheusPort));
        return answer;
    }

    @Override
    protected boolean shouldAddDefaultImage(List<ImageConfiguration> configs) {
        return super.shouldAddDefaultImage(configs) || Configs.asBoolean((String)this.getConfig(Config.enabled));
    }

    private void addPortIfValid(List<String> list, String port) {
        if (Strings.isNotBlank((String)port) && Integer.parseInt(port) != 0) {
            list.add(port);
        }
    }

    static class Java
    extends FromSelector.Default {
        private static final Properties defaultImageProps = new Properties();
        public static final String JAVA_DEFAULT_IMAGES_PROPERTIES = "/META-INF/fabric8/java-default-images.properties";

        public Java(MavenGeneratorContext context) {
            super(context, Java.getImageProp("generator.java.docker.upstream"), Java.getImageProp("generator.java.s2i.upstream"), Java.getImageProp("generator.java.docker.redhat"), Java.getImageProp("generator.java.s2i.redhat"));
        }

        private static String getImageProp(String key) {
            String val = defaultImageProps.getProperty(key);
            if (val == null) {
                throw new IllegalArgumentException("Cannot retrieve default value " + key + " from " + JAVA_DEFAULT_IMAGES_PROPERTIES);
            }
            return val;
        }

        static {
            try {
                defaultImageProps.load(Java.class.getResourceAsStream(JAVA_DEFAULT_IMAGES_PROPERTIES));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load default images properties /META-INF/fabric8/java-default-images.properties: " + e, e);
            }
        }
    }

    private static enum Config implements Configs.Key
    {
        enabled{
            {
                this.d = "false";
            }
        }
        ,
        webPort{
            {
                this.d = "8080";
            }
        }
        ,
        jolokiaPort{
            {
                this.d = "8778";
            }
        }
        ,
        prometheusPort{
            {
                this.d = "9779";
            }
        }
        ,
        baseDir{
            {
                this.d = "/deployments";
            }
        }
        ,
        assemblyRef{
            {
                this.d = "artifact-with-includes";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

