/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import java.util.regex.Pattern;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;

public abstract class FromSelector {
    private final MavenGeneratorContext context;
    private final Pattern REDHAT_VERSION_PATTERN = Pattern.compile("^.*\\.redhat-.*$");

    public FromSelector(MavenGeneratorContext context) {
        this.context = context;
    }

    public String getFrom() {
        PlatformMode mode = this.context.getMode();
        OpenShiftBuildStrategy strategy = this.context.getStrategy();
        if (mode == PlatformMode.openshift && strategy == OpenShiftBuildStrategy.s2i) {
            return this.getS2iBuildFrom();
        }
        return this.getDockerBuildFrom();
    }

    protected abstract String getDockerBuildFrom();

    protected abstract String getS2iBuildFrom();

    public boolean isRedHat() {
        MavenProject project = this.context.getProject();
        Plugin plugin = project.getPlugin("io.fabric8:fabric8-maven-plugin");
        if (plugin == null) {
            return false;
        }
        String version = plugin.getVersion();
        return this.REDHAT_VERSION_PATTERN.matcher(version).matches();
    }

    public static class Default
    extends FromSelector {
        private final String vanillaDocker;
        private final String vanillaS2i;
        private final String redhatDocker;
        private final String redhatS2i;

        public Default(MavenGeneratorContext context, String vanillaDocker, String vanillaS2i, String redhatDocker, String redhatS2i) {
            super(context);
            this.vanillaDocker = vanillaDocker;
            this.vanillaS2i = vanillaS2i;
            this.redhatDocker = redhatDocker;
            this.redhatS2i = redhatS2i;
        }

        @Override
        protected String getDockerBuildFrom() {
            return this.isRedHat() ? this.redhatDocker : this.vanillaDocker;
        }

        @Override
        protected String getS2iBuildFrom() {
            return this.isRedHat() ? this.redhatS2i : this.vanillaS2i;
        }
    }
}

