/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.Configs;
import java.util.Properties;

public class GeneratorConfig {
    private static final String GENERATOR_PROP_PREFIX = "fabri8.generator";
    private final String name;
    private final ProcessorConfig config;
    private final Properties properties;

    public GeneratorConfig(Properties properties, String name, ProcessorConfig config) {
        this.config = config != null ? config : ProcessorConfig.EMPTY;
        this.name = name;
        this.properties = properties;
    }

    public String get(Configs.Key key) {
        return this.get(key, key.def());
    }

    public String get(Configs.Key key, String defaultVal) {
        String fullKey;
        String keyVal = key != null ? key.name() : "";
        String val = this.config.getConfig(this.name, key.name());
        if (val == null && (val = this.properties.getProperty(fullKey = "fabri8.generator." + this.name + "." + key)) == null) {
            val = System.getProperty(fullKey);
        }
        return val != null ? val : defaultVal;
    }
}

