/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.generator.api;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.generator.api.Generator;
import io.fabric8.maven.generator.api.GeneratorConfiguration;
import io.fabric8.maven.generator.api.MavenGeneratorContext;
import org.apache.maven.project.MavenProject;

public abstract class BaseGenerator
implements Generator {
    private final MavenGeneratorContext context;
    private final String name;
    private final GeneratorConfiguration config;

    public BaseGenerator(MavenGeneratorContext context, String name) {
        this.context = context;
        this.name = name;
        this.config = new GeneratorConfiguration(this.getName(), context.getConfig());
    }

    protected MavenProject getProject() {
        return this.context.getProject();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public MavenGeneratorContext getContext() {
        return this.context;
    }

    public GeneratorConfiguration getConfig() {
        return this.config;
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }
}

