/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.osio;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.util.Collections;
import java.util.Map;

public class SpaceLabelEnricher
extends BaseEnricher {
    private static final String SPACE_LABEL = "space";

    public SpaceLabelEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "osio-space-label");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectMetaBuilder>(){

            public void visit(ObjectMetaBuilder o) {
                if (o != null) {
                    Map<String, String> labels;
                    String space = SpaceLabelEnricher.this.getConfig(Config.space);
                    if (o != null) {
                        labels = o.getLabels();
                        labels.put(SpaceLabelEnricher.SPACE_LABEL, space);
                    } else {
                        labels = Collections.singletonMap(SpaceLabelEnricher.SPACE_LABEL, space);
                    }
                    o.addToLabels(labels);
                    o.getLabels();
                }
            }
        });
    }

    static enum Config implements Configs.Key
    {
        space;


        public String def() {
            return null;
        }
    }
}

