/*
 * Copyright 2018 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version
 * 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.  See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.fabric8.maven.enricher.osio;

import java.util.HashMap;
import java.util.Map;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;

/**
 * Apply a label containing the OpenShift.io space to be associated
 * with resources generated by this plugin.
 */
public class SpaceLabelEnricher extends BaseEnricher {

    private static final String SPACE_LABEL = "space";

    static enum Config implements Configs.Key {
        space;

        @Override
        public String def() {
            // No default value
            return null;
        }
    }

    public SpaceLabelEnricher(EnricherContext buildContext) {
        super(buildContext, "osio-space-label");
    }

    @Override
    public Map<String, String> getLabels(Kind kind) {
        String space = getConfig(Config.space);

        if (space != null && !space.trim().isEmpty()) {
            getLog().verbose("Setting space label '%s' on %s", space, kind.toString().toLowerCase());

            Map<String, String> labels = new HashMap<>(1);
            labels.put(SPACE_LABEL, space);
            return labels;
        }

        return super.getLabels(kind);
    }

}
