/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.git;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.enricher.api.Kinds;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.URLUtils;
import java.io.File;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitEnricher
extends BaseEnricher {
    public GitEnricher(EnricherContext buildContext) {
        super(buildContext, "git");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAnnotations(Kind kind) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (Kinds.isDeployOrReplicaKind((Kind)kind) || kind == Kind.SERVICE) {
            Iterable<Throwable> it;
            boolean connectError;
            boolean notFound;
            Throwable cause;
            KubernetesClient kubernetes;
            String repoName;
            block36: {
                MavenProject project = this.getProject();
                if (project == null) {
                    return null;
                }
                MavenProject rootProject = MavenUtil.getRootProject((MavenProject)project);
                File basedir = rootProject.getBasedir();
                if (basedir == null) {
                    basedir = project.getBasedir();
                }
                if (basedir == null) {
                    basedir = new File(System.getProperty("basedir", "."));
                }
                repoName = rootProject.getArtifactId();
                kubernetes = this.getKubernetes();
                String userEnvVar = this.getConfig(Config.useEnvVar);
                String username = Systems.getEnvVarOrSystemProperty((String)userEnvVar);
                if (Strings.isNullOrBlank((String)username)) {
                    username = "gogsadmin";
                }
                if (Strings.isNotBlank((String)repoName) && Strings.isNotBlank((String)username)) {
                    String gitCommitId = null;
                    try (Repository repository = this.getGitRepository(basedir);){
                        if (repository != null) {
                            String branch = repository.getBranch();
                            if (Strings.isNotBlank((String)branch)) {
                                answer.put("fabric8.io/git-branch", branch);
                            }
                            gitCommitId = this.getGitCommitId(repository);
                        }
                    }
                    if (this.isOffline()) {
                        this.getLog().info("Not looking for kubernetes service gogs as in offline mode");
                    } else {
                        try {
                            if (Strings.isNotBlank(gitCommitId)) {
                                answer.put("fabric8.io/git-commit", gitCommitId);
                                String gogsUrl = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"gogs", (String)kubernetes.getNamespace(), (String)"http", (boolean)true);
                                String rootGitUrl = URLUtils.pathJoin((String[])new String[]{gogsUrl, username, repoName});
                                rootGitUrl = URLUtils.pathJoin((String[])new String[]{rootGitUrl, "commit", gitCommitId});
                                if (Strings.isNotBlank((String)rootGitUrl)) {
                                    answer.put("fabric8.io/git-url", rootGitUrl);
                                }
                            }
                        }
                        catch (Throwable e) {
                            cause = e;
                            this.getLog().warn("Failed: " + e, new Object[]{e});
                            e.printStackTrace();
                            notFound = false;
                            connectError = false;
                            it = GitEnricher.createExceptionIterable(e);
                            for (Throwable t : it) {
                                notFound = t instanceof IllegalArgumentException || t.getMessage() != null && t.getMessage().startsWith("No kubernetes service could be found for name");
                                connectError = t instanceof ConnectException || "No route to host".equals(t.getMessage());
                                if (!connectError) continue;
                                cause = t;
                                break;
                            }
                            if (connectError) {
                                this.warnIfInCDBuild("Cannot connect to Kubernetes to find gogs service URL: " + cause.getMessage());
                                break block36;
                            }
                            if (notFound) {
                                this.warnIfInCDBuild(cause.getMessage());
                                break block36;
                            }
                            this.warnIfInCDBuild("Cannot find gogs service URL: " + cause, cause);
                        }
                    }
                } else {
                    this.warnIfInCDBuild("Cannot auto-default GIT_URL as there is no environment variable `" + userEnvVar + "` defined so we can't guess the Gogs build URL");
                }
            }
            if (Strings.isNotBlank((String)repoName)) {
                String buildId = Systems.getEnvVarOrSystemProperty((String)"BUILD_ID");
                if (Strings.isNullOrBlank((String)buildId)) {
                    this.warnIfInCDBuild("Cannot find $BUILD_ID so must not be inside a Jenkins build");
                } else {
                    answer.put("fabric8.io/build-id", buildId);
                    if (this.isOffline()) {
                        this.getLog().info("Not looking for kubernetes service jenkins as in offline mode");
                    } else {
                        String jobUrl = null;
                        try {
                            String jenkinsUrl = KubernetesHelper.getServiceURL((KubernetesClient)kubernetes, (String)"jenkins", (String)kubernetes.getNamespace(), (String)"http", (boolean)true);
                            jobUrl = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/job", repoName});
                        }
                        catch (Throwable e) {
                            cause = e;
                            notFound = false;
                            connectError = false;
                            it = GitEnricher.createExceptionIterable(e);
                            for (Throwable t : it) {
                                connectError = t instanceof ConnectException || "No route to host".equals(t.getMessage());
                                boolean bl = notFound = t instanceof IllegalArgumentException || t.getMessage() != null && t.getMessage().startsWith("No kubernetes service could be found for name");
                                if (!connectError && !notFound) continue;
                                cause = t;
                                break;
                            }
                            if (connectError) {
                                this.warnIfInCDBuild("Cannot connect to Kubernetes to find jenkins service URL: " + cause.getMessage());
                            }
                            if (notFound) {
                                this.warnIfInCDBuild(cause.getMessage());
                            }
                            this.warnIfInCDBuild("Cannot find jenkins service URL: " + cause, cause);
                        }
                        if (Strings.isNotBlank((String)jobUrl)) {
                            jobUrl = URLUtils.pathJoin((String[])new String[]{jobUrl, buildId});
                            answer.put("fabric8.io/build-url", jobUrl);
                        }
                    }
                }
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getGitCommitId(Repository repository) {
        try {
            if (repository != null) {
                this.getLog().info("Looking at repo with directory " + repository.getDirectory());
                Iterable logs = new Git(repository).log().call();
                Iterator iterator = logs.iterator();
                if (iterator.hasNext()) {
                    RevCommit rev = (RevCommit)iterator.next();
                    String string = rev.getName();
                    return string;
                }
                this.warnIfInCDBuild("Cannot find git commit SHA as no commits could be found");
            } else {
                this.warnIfInCDBuild("Cannot find git commit SHA as no git repository could be found");
            }
        }
        catch (Exception e) {
            this.warnIfInCDBuild("Failed to find git commit id. " + e, e);
        }
        finally {
            if (repository != null) {
                try {
                    repository.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    protected Repository getGitRepository(File basedir) {
        try {
            File gitFolder = GitHelpers.findGitFolder((File)basedir);
            if (gitFolder == null) {
                this.warnIfInCDBuild("Could not find .git folder based on the current basedir of " + basedir);
                return null;
            }
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).setGitDir(gitFolder)).build();
            if (repository == null) {
                this.warnIfInCDBuild("No .git/config file could be found so cannot annotate kubernetes resources with git commit SHA and branch");
            }
            return repository;
        }
        catch (Exception e) {
            this.warnIfInCDBuild("Failed to initialise Git Repository: " + e, e);
            return null;
        }
    }

    protected static Iterable<Throwable> createExceptionIterable(Throwable exception) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.add(current);
        }
        Collections.reverse(throwables);
        return throwables;
    }

    protected void warnIfInCDBuild(String message) {
        if (this.isInCDBuild()) {
            this.getLog().warn(message);
        } else {
            this.getLog().debug(message);
        }
    }

    protected boolean isInCDBuild() {
        return Configs.asBoolean((String)this.getConfig(Config.cdBuild));
    }

    protected void warnIfInCDBuild(String message, Throwable exception) {
        if (this.isInCDBuild()) {
            this.getLog().warn(message, new Object[]{exception});
        } else {
            this.getLog().debug(message, new Object[]{exception});
        }
    }

    private static enum Config implements Configs.Key
    {
        cdBuild{
            {
                this.d = "true";
            }
        }
        ,
        useEnvVar{
            {
                this.d = "JENKINS_GOGS_USER";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

