/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.deprecated;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GrafanaLinkEnricher
extends BaseEnricher {
    public GrafanaLinkEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "f8-deprecated-cd-grafana-link");
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (kind.isController()) {
            String url = this.findGrafanaLink();
            return url != null ? Collections.singletonMap("fabric8.io/metrics-path", url) : null;
        }
        return null;
    }

    private String findGrafanaLink() {
        String defaultDashboard = this.detectDefaultDashboard();
        String query = "";
        String projectName = null;
        String version = null;
        if (StringUtils.isBlank(projectName)) {
            projectName = this.getContext().getGav().getArtifactId();
        }
        if (StringUtils.isBlank(version)) {
            version = this.getContext().getGav().getVersion();
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            query = query + "&var-project=" + projectName;
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            query = query + "&var-version=" + version;
        }
        if (query.startsWith("&")) {
            query = "?" + query.substring(1);
        }
        return String.format("dashboard/file/%s%s", defaultDashboard, query);
    }

    protected String detectDefaultDashboard() {
        String dashboard = this.getConfig(Config.metricsDashboard);
        if (StringUtils.isNotBlank((CharSequence)dashboard)) {
            return dashboard;
        }
        if (this.getContext().getProjectClassLoaders().isClassInCompileClasspath(false, new String[]{"org.apache.camel.CamelContext"})) {
            return "camel-routes.json";
        }
        return "kubernetes-pods.json";
    }

    private static enum Config implements Configs.Key
    {
        metricsDashboard;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

