/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.deprecated;

import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.maven.enricher.deprecated.AbstractLiveEnricher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;

public class DocLinkEnricher
extends AbstractLiveEnricher {
    public DocLinkEnricher(MavenEnricherContext buildContext) {
        super(buildContext, "f8-deprecated-link");
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (kind.isController()) {
            String url = this.findDocumentationUrl();
            return url != null ? Collections.singletonMap(Fabric8Annotations.DOCS_URL.value(), url) : null;
        }
        return null;
    }

    private String getDocumentationUrl() {
        if (this.getContext() instanceof MavenEnricherContext) {
            MavenEnricherContext mavenEnricherContext = (MavenEnricherContext)this.getContext();
            for (MavenProject currentProject = mavenEnricherContext.getProject(); currentProject != null; currentProject = currentProject.getParent()) {
                Site site;
                DistributionManagement distributionManagement = currentProject.getDistributionManagement();
                if (distributionManagement == null || (site = distributionManagement.getSite()) == null) continue;
                return site.getUrl();
            }
        }
        return null;
    }

    protected String findDocumentationUrl() {
        String url = this.getDocumentationUrl();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            url = DocLinkEnricher.replaceProperties(url, this.getContext().getConfiguration().getProperties());
            try {
                String publicUrl;
                int idx2;
                String urlToParse = url;
                int idx = url.indexOf("://");
                if (idx > 0 && (idx2 = url.substring(0, idx).lastIndexOf(58)) >= 0 && idx2 < idx) {
                    urlToParse = url.substring(idx2 + 1);
                }
                URL u = new URL(urlToParse);
                String serviceName = u.getHost();
                String protocol = u.getProtocol();
                if (this.isOnline() && StringUtils.isNotBlank((CharSequence)(publicUrl = this.getExternalServiceURL(serviceName, protocol)))) {
                    return String.format("%s/%s", publicUrl, u.getPath());
                }
            }
            catch (MalformedURLException e) {
                this.getLog().error("Failed to parse URL: %s. %s", new Object[]{url, e});
            }
            return url;
        }
        return null;
    }

    protected static String replaceProperties(String text, Properties properties) {
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String pattern = "${" + key + "}";
            text = StringUtils.replace((String)text, (String)pattern, (String)value.toString());
        }
        return text;
    }
}

