/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.dependency;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class DependencyEnricher
extends BaseEnricher {
    private static String DEPENDENCY_KUBERNETES_YAML = "/META-INF/fabric8/kubernetes.yml";
    private Set<File> dependencyArtifacts = new HashSet<File>();

    public DependencyEnricher(EnricherContext buildContext) {
        super(buildContext, "dependency");
        Set artifacts = this.isIncludeTransitive() ? buildContext.getProject().getArtifacts() : buildContext.getProject().getDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            if (!"compile".equals(artifact.getScope()) || !"jar".equals(artifact.getType())) continue;
            this.dependencyArtifacts.add(artifact.getFile());
        }
    }

    public void adapt(KubernetesListBuilder builder) {
        for (File artifact : this.dependencyArtifacts) {
            try {
                URL url = new URL("jar:" + artifact.toURI().toURL() + "!" + DEPENDENCY_KUBERNETES_YAML);
                InputStream is = url.openStream();
                KubernetesList resources = (KubernetesList)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(is, KubernetesList.class);
                builder.addToItems(resources.getItems().toArray(new HasMetadata[0]));
            }
            catch (IOException e) {
                this.getLog().debug("Skipping " + artifact.toString() + ": " + e);
            }
        }
    }

    protected boolean isIncludeTransitive() {
        return Configs.asBoolean((String)this.getConfig(Config.includeTransitive));
    }

    private static enum Config implements Configs.Key
    {
        includeTransitive{
            {
                this.d = "true";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

