/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.model.Configuration;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherConfig;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class BaseEnricher
implements Enricher {
    private final EnricherConfig config;
    private final String name;
    protected EnricherContext enricherContext;
    public static final String FABRIC8_GENERATED_CONTAINERS = "FABRIC8_GENERATED_CONTAINERS";
    public static final String NEED_IMAGECHANGE_TRIGGERS = "IMAGECHANGE_TRIGGER";
    protected Logger log;

    public BaseEnricher(EnricherContext enricherContext, String name) {
        this.enricherContext = enricherContext;
        this.config = new EnricherConfig(name, enricherContext.getConfiguration());
        this.log = new PrefixedLogger(name, enricherContext.getLog());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
    }

    @Override
    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
    }

    protected Logger getLog() {
        return this.log;
    }

    protected Optional<List<ImageConfiguration>> getImages() {
        return this.enricherContext.getConfiguration().getImages();
    }

    protected boolean hasImageConfiguration() {
        return !this.enricherContext.getConfiguration().getImages().orElse(Collections.emptyList()).isEmpty();
    }

    protected Configuration getConfiguration() {
        return this.enricherContext.getConfiguration();
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected boolean hasConfig(Configs.Key key) {
        return this.config.get(key) != null;
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected Map<String, String> getRawConfig() {
        return this.config.getRawConfig();
    }

    protected EnricherContext getContext() {
        return this.enricherContext;
    }

    protected boolean isOpenShiftMode() {
        Properties properties = this.getContext().getConfiguration().getProperties();
        if (properties != null) {
            return RuntimeMode.isOpenShiftMode((Properties)properties);
        }
        return false;
    }

    protected List<String> getProcessingInstructionViaKey(String key) {
        ArrayList<String> containers = new ArrayList<String>();
        if (this.enricherContext.getProcessingInstructions() != null && this.enricherContext.getProcessingInstructions().get(key) != null) {
            containers.addAll(Arrays.asList(this.enricherContext.getProcessingInstructions().get(key).split(",")));
        }
        return containers;
    }

    protected Boolean isAutomaticTriggerEnabled(MavenEnricherContext enricherContext, Boolean defaultValue) {
        if (enricherContext.getProperty("fabric8.openshift.enableAutomaticTrigger") != null) {
            return Boolean.parseBoolean(enricherContext.getProperty("fabric8.openshift.enableAutomaticTrigger").toString());
        }
        return defaultValue;
    }

    protected Long getOpenshiftDeployTimeoutInSeconds(MavenEnricherContext enricherContext, Long defaultValue) {
        if (enricherContext.getProperty("fabric8.openshift.deployTimeoutSeconds") != null) {
            return Long.parseLong(enricherContext.getProperty("fabric8.openshift.deployTimeoutSeconds").toString());
        }
        return defaultValue;
    }

    protected Boolean getImageChangeTriggerFlag(Boolean defaultValue) {
        if (this.getContext().getProperty("fabric8.openshift.imageChangeTriggers") != null) {
            return Boolean.parseBoolean(this.getContext().getProperty("fabric8.openshift.imageChangeTriggers").toString());
        }
        return defaultValue;
    }

    protected Boolean getTrimImageInContainerSpecFlag(Boolean defaultValue) {
        if (this.getContext().getProperty("fabric8.openshift.trimImageInContainerSpec") != null) {
            return Boolean.parseBoolean(this.getContext().getProperty("fabric8.openshift.trimImageInContainerSpec").toString());
        }
        return defaultValue;
    }

    protected int getReplicaCount(KubernetesListBuilder builder, ResourceConfig xmlResourceConfig, int defaultValue) {
        if (xmlResourceConfig != null) {
            List items = builder.buildItems();
            for (HasMetadata item : items) {
                if (item instanceof Deployment && ((Deployment)item).getSpec().getReplicas() != null) {
                    return ((Deployment)item).getSpec().getReplicas();
                }
                if (!(item instanceof DeploymentConfig) || ((DeploymentConfig)item).getSpec().getReplicas() == null) continue;
                return ((DeploymentConfig)item).getSpec().getReplicas();
            }
            return xmlResourceConfig.getReplicas() > 0 ? xmlResourceConfig.getReplicas() : defaultValue;
        }
        return defaultValue;
    }

    protected void setProcessingInstruction(String key, List<String> containerNames) {
        HashMap<String, String> processingInstructionsMap = new HashMap<String, String>();
        if (this.enricherContext.getProcessingInstructions() != null) {
            processingInstructionsMap.putAll(this.enricherContext.getProcessingInstructions());
        }
        processingInstructionsMap.put(key, String.join((CharSequence)",", containerNames));
        this.enricherContext.setProcessingInstructions(processingInstructionsMap);
    }
}

