/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.Configs;
import java.util.Properties;

public class EnricherConfig {
    private static final String ENRICHER_PROP_PREFIX = "fabric8.enricher";
    private final String name;
    private final ProcessorConfig config;
    private final Properties projectProperties;

    public EnricherConfig(Properties projectProperties, String name, ProcessorConfig config) {
        this.config = config != null ? config : ProcessorConfig.INCLUDE_ALL;
        this.name = name;
        this.projectProperties = projectProperties;
    }

    public String get(Configs.Key key) {
        return this.get(key, key.def());
    }

    public String get(Configs.Key key, String defaultVal) {
        String val = this.config.getConfig(this.name, key.name());
        if (val == null) {
            String fullKey = "fabric8.enricher." + this.name + "." + key;
            val = Configs.getPropertyWithSystemAsFallback((Properties)this.projectProperties, (String)fullKey);
        }
        return val != null ? val : defaultVal;
    }
}

