/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api.util;

import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.maven.core.util.JSONUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.utils.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

public class InitContainerHandler {
    public static final String INIT_CONTAINER_ANNOTATION = "pod.alpha.kubernetes.io/init-containers";
    Logger log;

    public InitContainerHandler(Logger log) {
        this.log = log;
    }

    public boolean hasInitContainer(PodTemplateSpecBuilder builder, String name) {
        return this.getInitContainer(builder, name) != null;
    }

    public JSONObject getInitContainer(PodTemplateSpecBuilder builder, String name) {
        String initContainerAnnotation;
        if (builder.hasMetadata().booleanValue() && Strings.isNotBlank((String)(initContainerAnnotation = (String)builder.buildMetadata().getAnnotations().get(INIT_CONTAINER_ANNOTATION)))) {
            JSONArray initContainers = new JSONArray(initContainerAnnotation);
            for (int i = 0; i < initContainers.length(); ++i) {
                JSONObject obj = initContainers.getJSONObject(i);
                String existingName = obj.getString("name");
                if (!name.equals(existingName)) continue;
                return obj;
            }
        }
        return null;
    }

    public void appendInitContainer(PodTemplateSpecBuilder builder, JSONObject initContainer) {
        String name = initContainer.getString("name");
        JSONObject existing = this.getInitContainer(builder, name);
        if (existing != null) {
            if (JSONUtil.equals((JSONObject)existing, (JSONObject)initContainer)) {
                this.log.warn("Trying to add init-container %s a second time. Ignoring ....", new Object[]{name});
                return;
            }
            throw new IllegalArgumentException(String.format("PodSpec %s already contains a different init container with name %s but can not add a second one with the same name. Please choose a different name for the init container", builder.build().getMetadata().getName(), name));
        }
        this.ensureMetadata(builder);
        String initContainerAnnotation = (String)builder.buildMetadata().getAnnotations().get(INIT_CONTAINER_ANNOTATION);
        JSONArray initContainers = Strings.isNullOrBlank((String)initContainerAnnotation) ? new JSONArray() : new JSONArray(initContainerAnnotation);
        initContainers.put((Object)initContainer);
        ((PodTemplateSpecFluent.MetadataNested)builder.editMetadata().addToAnnotations(INIT_CONTAINER_ANNOTATION, initContainers.toString())).endMetadata();
    }

    private void ensureMetadata(PodTemplateSpecBuilder obj) {
        if (obj.buildMetadata() == null) {
            obj.withNewMetadata().endMetadata();
        }
    }
}

