/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.GoalFinder;
import io.fabric8.maven.core.util.OpenShiftDependencyResources;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class EnricherContext {
    private MavenProject project;
    private Logger log;
    private List<ImageConfiguration> images;
    private String namespace;
    private ProcessorConfig config = ProcessorConfig.EMPTY;
    private boolean useProjectClasspath;
    private OpenShiftDependencyResources openshiftDependencyResources;
    private MavenSession session;
    private GoalFinder goalFinder;

    private EnricherContext() {
    }

    public MavenProject getProject() {
        return this.project;
    }

    public List<ImageConfiguration> getImages() {
        return this.images;
    }

    public Logger getLog() {
        return this.log;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public OpenShiftDependencyResources getOpenshiftDependencyResources() {
        return this.openshiftDependencyResources;
    }

    public boolean runningWithGoal(String ... goals) throws MojoExecutionException {
        for (String goal : goals) {
            if (!this.goalFinder.runningWithGoal(this.project, this.session, goal)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private EnricherContext ctx = new EnricherContext();

        public Builder session(MavenSession session) {
            this.ctx.session = session;
            return this;
        }

        public Builder goalFinder(GoalFinder goalFinder) {
            this.ctx.goalFinder = goalFinder;
            return this;
        }

        public Builder log(Logger log) {
            this.ctx.log = log;
            return this;
        }

        public Builder project(MavenProject project) {
            this.ctx.project = project;
            return this;
        }

        public Builder config(ProcessorConfig config) {
            this.ctx.config = config;
            return this;
        }

        public Builder images(List<ImageConfiguration> images) {
            this.ctx.images = images;
            return this;
        }

        public Builder namespace(String namespace) {
            this.ctx.namespace = namespace;
            return this;
        }

        public Builder useProjectClasspath(boolean useProjectClasspath) {
            this.ctx.useProjectClasspath = useProjectClasspath;
            return this;
        }

        public Builder openshiftDependencyResources(OpenShiftDependencyResources openShiftDependencyResources) {
            this.ctx.openshiftDependencyResources = openShiftDependencyResources;
            return this;
        }

        public EnricherContext build() {
            return this.ctx;
        }
    }
}

