/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherConfig;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.utils.Strings;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseEnricher
implements Enricher {
    public static final String INIT_CONTAINER_ANNOTATION = "pod.alpha.kubernetes.io/init-containers";
    private final EnricherConfig config;
    private final String name;
    private EnricherContext buildContext;
    protected Logger log;

    public BaseEnricher(EnricherContext buildContext, String name) {
        this.buildContext = buildContext;
        this.config = new EnricherConfig(buildContext.getProject().getProperties(), name, buildContext.getConfig());
        this.log = new PrefixedLogger(name, buildContext.getLog());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getLabels(Kind kind) {
        return null;
    }

    @Override
    public Map<String, String> getAnnotations(Kind kind) {
        return null;
    }

    @Override
    public void adapt(KubernetesListBuilder builder) {
    }

    @Override
    public void addMissingResources(KubernetesListBuilder builder) {
    }

    @Override
    public Map<String, String> getSelector(Kind kind) {
        return null;
    }

    protected MavenProject getProject() {
        if (this.buildContext != null) {
            return this.buildContext.getProject();
        }
        return null;
    }

    protected Logger getLog() {
        return this.log;
    }

    protected List<ImageConfiguration> getImages() {
        return this.buildContext.getImages();
    }

    protected boolean hasImageConfiguration() {
        return !this.buildContext.getImages().isEmpty();
    }

    protected String getConfig(Configs.Key key) {
        return this.config.get(key);
    }

    protected String getConfig(Configs.Key key, String defaultVal) {
        return this.config.get(key, defaultVal);
    }

    protected EnricherContext getContext() {
        return this.buildContext;
    }

    protected boolean isOpenShiftMode() {
        Properties properties;
        MavenProject project = this.getProject();
        if (project != null && (properties = project.getProperties()) != null) {
            return PlatformMode.isOpenShiftMode((Properties)properties);
        }
        return false;
    }

    protected void ensureMetadata(PodTemplateSpecBuilder obj) {
        if (obj.buildMetadata() == null) {
            obj.withNewMetadata().endMetadata();
        }
    }

    protected void addInitContainer(PodTemplateSpecBuilder builder, JSONObject initContainer) {
        this.ensureMetadata(builder);
        String initContainerAnnotation = (String)builder.buildMetadata().getAnnotations().get(INIT_CONTAINER_ANNOTATION);
        JSONArray initContainers = Strings.isNullOrBlank((String)initContainerAnnotation) ? new JSONArray() : new JSONArray(initContainerAnnotation);
        initContainers.put((Object)initContainer);
        ((PodTemplateSpecFluent.MetadataNested)builder.editMetadata().addToAnnotations(INIT_CONTAINER_ANNOTATION, initContainers.toString())).endMetadata();
    }
}

