/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.api;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;

public abstract class AbstractHealthCheckEnricher
extends BaseEnricher {
    public AbstractHealthCheckEnricher(EnricherContext buildContext, String name) {
        super(buildContext, name);
    }

    @Override
    public void addMissingResources(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ContainerBuilder>(){

            public void visit(ContainerBuilder container) {
                Probe probe;
                if (container.getReadinessProbe() == null && (probe = AbstractHealthCheckEnricher.this.getReadinessProbe()) != null) {
                    AbstractHealthCheckEnricher.this.log.info("Adding readiness " + AbstractHealthCheckEnricher.this.describe(probe), new Object[0]);
                    container.withReadinessProbe(probe);
                }
                if (container.getLivenessProbe() == null && (probe = AbstractHealthCheckEnricher.this.getLivenessProbe()) != null) {
                    AbstractHealthCheckEnricher.this.log.info("Adding liveness " + AbstractHealthCheckEnricher.this.describe(probe), new Object[0]);
                    container.withLivenessProbe(probe);
                }
            }
        });
    }

    private String describe(Probe probe) {
        StringBuilder desc = new StringBuilder("probe");
        if (probe.getHttpGet() != null) {
            desc.append(" on port ");
            desc.append(probe.getHttpGet().getPort().getIntVal());
            desc.append(", path='");
            desc.append(probe.getHttpGet().getPath());
            desc.append("'");
            desc.append(", scheme='");
            desc.append(probe.getHttpGet().getScheme());
            desc.append("'");
        }
        if (probe.getInitialDelaySeconds() != null) {
            desc.append(", with initial delay ");
            desc.append(probe.getInitialDelaySeconds());
            desc.append(" seconds");
        }
        if (probe.getPeriodSeconds() != null) {
            desc.append(", with period ");
            desc.append(probe.getPeriodSeconds());
            desc.append(" seconds");
        }
        return desc.toString();
    }

    protected abstract Probe getReadinessProbe();

    protected abstract Probe getLivenessProbe();
}

